/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.criteria;

import java.util.List;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.criteria.AbstractCar;
import org.hibernate.search.test.query.criteria.Bike;
import org.hibernate.search.test.query.criteria.CombiCar;
import org.hibernate.search.test.query.criteria.SportCar;

public class MixedCriteriaTest
extends SearchTestCase {
    public void testCriteriaWithFilteredEntity() throws Exception {
        this.indexTestData();
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(TestConstants.getTargetLuceneVersion(), new String[]{"kurztext"}, TestConstants.standardAnalyzer);
        Query query = parser.parse("combi OR sport");
        Criteria criteria = session.createCriteria(AbstractCar.class);
        criteria.add((Criterion)Restrictions.eq((String)"hasColor", (Object)Boolean.FALSE));
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{AbstractCar.class}).setCriteriaQuery(criteria);
        List result = hibQuery.list();
        MixedCriteriaTest.assertEquals((int)2, (int)result.size());
        tx.commit();
        session.close();
    }

    public void testCriteriaWithoutFilteredEntity() throws Exception {
        this.indexTestData();
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(TestConstants.getTargetLuceneVersion(), new String[]{"kurztext"}, TestConstants.standardAnalyzer);
        Query query = parser.parse("combi OR sport");
        Criteria criteria = session.createCriteria(AbstractCar.class);
        criteria.add((Criterion)Restrictions.eq((String)"hasColor", (Object)Boolean.FALSE));
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[0]).setCriteriaQuery(criteria);
        List result = hibQuery.list();
        MixedCriteriaTest.assertEquals((int)2, (int)result.size());
        tx.commit();
        session.close();
    }

    public void testCriteriaWithMultipleEntities() throws Exception {
        this.indexTestData();
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(TestConstants.getTargetLuceneVersion(), new String[]{"kurztext"}, TestConstants.standardAnalyzer);
        Query query = parser.parse("combi OR sport");
        Criteria criteria = session.createCriteria(AbstractCar.class);
        criteria.add((Criterion)Restrictions.eq((String)"hasColor", (Object)Boolean.FALSE));
        try {
            FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{AbstractCar.class, Bike.class}).setCriteriaQuery(criteria);
            hibQuery.list();
            MixedCriteriaTest.fail();
        }
        catch (SearchException se) {
            MixedCriteriaTest.assertEquals((String)"Cannot mix criteria and multiple entity types", (String)se.getMessage());
        }
        tx.commit();
        session.close();
    }

    private void indexTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        CombiCar combi = new CombiCar();
        combi.setKurztext("combi");
        s.persist((Object)combi);
        SportCar sport = new SportCar();
        sport.setKurztext("sport");
        s.persist((Object)sport);
        Bike bike = new Bike();
        bike.setKurztext("bike");
        s.persist((Object)bike);
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{AbstractCar.class, CombiCar.class, SportCar.class, Bike.class};
    }
}

