/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.functionality;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexReader;
import org.hibernate.search.test.reader.functionality.ExtendedSharingBufferReaderProvider;
import org.junit.Assert;
import org.junit.Test;

public class SharingBufferIndexProviderTest {
    private final ExtendedSharingBufferReaderProvider readerProvider = new ExtendedSharingBufferReaderProvider();
    private final CountDownLatch startSignal = new CountDownLatch(1);
    private final Runnable searchTask = new SearchTask();
    private final Runnable changeTask = new ChangeTask();
    private final Runnable directorySwitchTask = new DirectorySwitchTask();
    private final AtomicInteger countDoneSearches = new AtomicInteger();
    private final AtomicInteger countDoneIndexmods = new AtomicInteger();
    private static final int SEARCHES_NUM = 10000;

    @Test
    public void testStressingMock() throws InterruptedException {
        this.readerProvider.initialize(null, null);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(50);
        for (int i = 0; i < 10000; ++i) {
            executor.execute(this.makeTask(i));
        }
        executor.shutdown();
        this.startSignal.countDown();
        executor.awaitTermination(500L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"memory leak: holding a reference to some unused IndexReader", (boolean)this.readerProvider.areAllOldReferencesGone());
        for (ExtendedSharingBufferReaderProvider.MockIndexReader reader : this.readerProvider.getCreatedIndexReaders()) {
            if (this.readerProvider.isReaderCurrent(reader)) {
                Assert.assertTrue((String)"the most current reader should be open", (!reader.isClosed() ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)"an IndexReader is still open", (boolean)reader.isClosed());
        }
        Assert.assertEquals((long)10000L, (long)this.countDoneSearches.get());
        Assert.assertEquals((long)1000L, (long)this.countDoneIndexmods.get());
    }

    private Runnable makeTask(int i) {
        if (i % 100 == 0) {
            return this.directorySwitchTask;
        }
        if (i % 10 == 0) {
            return this.changeTask;
        }
        return this.searchTask;
    }

    private class DirectorySwitchTask
    extends ChangeTask {
        private DirectorySwitchTask() {
        }

        @Override
        public void run() {
            super.run();
            Thread.yield();
            SharingBufferIndexProviderTest.this.readerProvider.swithDirectory();
        }
    }

    private class ChangeTask
    extends SearchTask {
        private ChangeTask() {
        }

        @Override
        public void run() {
            super.run();
            Thread.yield();
            SharingBufferIndexProviderTest.this.readerProvider.currentDPWasWritten();
            SharingBufferIndexProviderTest.this.countDoneIndexmods.incrementAndGet();
        }
    }

    private class SearchTask
    implements Runnable {
        private SearchTask() {
        }

        @Override
        public void run() {
            try {
                SharingBufferIndexProviderTest.this.startSignal.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            IndexReader fakeOpenReader = SharingBufferIndexProviderTest.this.readerProvider.openIndexReader();
            Thread.yield();
            SharingBufferIndexProviderTest.this.readerProvider.closeIndexReader(fakeOpenReader);
            SharingBufferIndexProviderTest.this.countDoneSearches.incrementAndGet();
        }
    }
}

