/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.reader.nrtreaders;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.AlternateDocument;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.hibernate.search.util.impl.ContextHelper;
import org.junit.Assert;

public class BasicNRTFunctionalityTest
extends SearchTestCase {
    public void testEntityResurrection() {
        Long id = 5L;
        Session session = this.getSessions().openSession();
        session.getTransaction().begin();
        AlternateDocument docOnInfinispan = new AlternateDocument(id, "On Infinispan", "a book about Infinispan", "content");
        session.persist((Object)docOnInfinispan);
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(AlternateDocument.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("Abstract").matching((Object)"Infinispan").createQuery();
        List list = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((long)1L, (long)list.size());
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        Object loadedDocument = session.load(AlternateDocument.class, (Serializable)id);
        session.delete(loadedDocument);
        session.getTransaction().commit();
        session.clear();
        session.getTransaction().begin();
        list = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((long)0L, (long)list.size());
        AlternateDocument docOnHibernate = new AlternateDocument(id, "On Hibernate", "a book about Hibernate", "content");
        session.persist((Object)docOnHibernate);
        session.getTransaction().commit();
        session.getTransaction().begin();
        list = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]).list();
        Assert.assertEquals((long)0L, (long)list.size());
        session.close();
    }

    public void testMultipleEntitiesPerIndex() throws Exception {
        SearchFactoryImplementor searchFactoryBySFI = ContextHelper.getSearchFactoryBySFI((SessionFactoryImplementor)((SessionFactoryImplementor)this.getSessions()));
        IndexManager documentsIndexManager = searchFactoryBySFI.getAllIndexesManager().getIndexManager("Documents");
        Assert.assertNotNull((Object)documentsIndexManager);
        Assert.assertTrue((boolean)documentsIndexManager.getClass().equals(NRTIndexManager.class));
        NRTIndexManager indexManager = (NRTIndexManager)documentsIndexManager;
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        Document document = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
        s.persist((Object)document);
        s.flush();
        s.persist((Object)new AlternateDocument(document.getId(), "Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        BasicNRTFunctionalityTest.assertEquals((int)0, (int)this.getDocumentNbrFromFilesystem(indexManager));
        BasicNRTFunctionalityTest.assertEquals((int)2, (int)this.getDocumentNbrFromReaderProvider(indexManager));
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        TermQuery q = new TermQuery(new Term("alt_title", "hibernate"));
        BasicNRTFunctionalityTest.assertEquals((String)"does not properly filter", (int)0, (int)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class}).list().size());
        BasicNRTFunctionalityTest.assertEquals((String)"does not properly filter", (int)1, (int)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class, AlternateDocument.class}).list().size());
        s.delete(s.get(AlternateDocument.class, (Serializable)document.getId()));
        s.getTransaction().commit();
        s.close();
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        BasicNRTFunctionalityTest.assertEquals((int)0, (int)this.getDocumentNbrFromFilesystem(indexManager));
        BasicNRTFunctionalityTest.assertEquals((int)1, (int)this.getDocumentNbrFromQuery(s));
        BasicNRTFunctionalityTest.assertEquals((int)1, (int)this.getDocumentNbrFromReaderProvider(indexManager));
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        BasicNRTFunctionalityTest.assertEquals((int)0, (int)this.getDocumentNbrFromFilesystem(indexManager));
        BasicNRTFunctionalityTest.assertEquals((int)0, (int)this.getDocumentNbrFromQuery(s));
        BasicNRTFunctionalityTest.assertEquals((int)0, (int)this.getDocumentNbrFromReaderProvider(indexManager));
        s.getTransaction().commit();
        s.close();
        ErrorHandler errorHandler = searchFactoryBySFI.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        MockErrorHandler mockErrorHandler = (MockErrorHandler)errorHandler;
        Assert.assertNull((String)"Errors detected in the backend!", (Object)mockErrorHandler.getLastException());
    }

    private int getDocumentNbrFromQuery(Session currentSession) {
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextQuery fullTextQuery = Search.getFullTextSession((Session)currentSession).createFullTextQuery((Query)luceneQuery, new Class[]{Document.class});
        return fullTextQuery.list().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbrFromReaderProvider(NRTIndexManager indexManager) {
        IndexReader reader = indexManager.getReaderProvider().openIndexReader();
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            indexManager.getReaderProvider().closeIndexReader(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbrFromFilesystem(NRTIndexManager documentsIndexManager) throws Exception {
        IndexReader reader = IndexReader.open((Directory)documentsIndexManager.getDirectoryProvider().getDirectory(), (boolean)true);
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, AlternateDocument.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.indexmanager", "near-real-time");
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

