/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.service;

import java.util.Properties;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.test.service.MyService;

public class MyServiceProvider
implements ServiceProvider<MyService> {
    private static volatile boolean active = false;
    private static volatile boolean simulateCircularDependency = false;
    private MyService foo;

    public void start(Properties properties, BuildContext context) {
        this.foo = new MyService();
        active = true;
        if (simulateCircularDependency) {
            context.getServiceManager().requestService(MyServiceProvider.class, context);
        }
    }

    public MyService getService() {
        return this.foo;
    }

    public void stop() {
        this.foo = null;
        active = false;
    }

    public static boolean isActive() {
        return active;
    }

    public static void resetActive() {
        active = false;
    }

    public static void setSimulateCircularDependency(boolean simulateCircularDependency) {
        MyServiceProvider.simulateCircularDependency = simulateCircularDependency;
    }
}

