/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.spatial.Coordinates;

@Entity
@Indexed
public class Event {
    @Id
    Integer id;
    @Field(store=Store.YES)
    String name;
    @Field(store=Store.YES, index=Index.YES)
    @Column(name="realdate")
    Date date;
    @Field(store=Store.YES, index=Index.YES)
    @NumericField
    double latitude;
    @Field(store=Store.YES, index=Index.YES)
    @NumericField
    double longitude;

    @Spatial(spatialMode=SpatialMode.GRID)
    public Coordinates getLocation() {
        return new Coordinates(){

            public Double getLatitude() {
                return Event.this.latitude;
            }

            public Double getLongitude() {
                return Event.this.longitude;
            }
        };
    }

    public Event(Integer id, String name, double latitude, double longitude, Date date) {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.date = date;
    }

    public Event() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Date getDate() {
        return this.date;
    }
}

