/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Date;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.bridge.ArrayBridgeTestEntity;

public class ArrayBridgeTest
extends SearchTestCase {
    private FullTextSession fullTextSession;
    private ArrayBridgeTestEntity withoutNull;
    private ArrayBridgeTestEntity withNullEntry;
    private ArrayBridgeTestEntity withNullEmbedded;
    private Date indexedDate;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    @Override
    public void tearDown() throws Exception {
        this.cleanData();
        ArrayBridgeTest.assertTrue((boolean)this.indexIsEmpty());
        super.tearDown();
    }

    private void prepareData() {
        this.indexedDate = new Date();
        Transaction tx = this.fullTextSession.beginTransaction();
        this.withoutNull = this.persistEntity((Session)this.fullTextSession, "Davide D'Alto");
        this.withoutNull.setNullIndexed(new ArrayBridgeTestEntity.Language[]{ArrayBridgeTestEntity.Language.ITALIAN, ArrayBridgeTestEntity.Language.ENGLISH});
        this.withoutNull.setNumericNullIndexed(new Integer[]{1, 2});
        this.withoutNull.setNullNotIndexed(new String[]{"DaltoValue", "DavideValue"});
        this.withoutNull.setNumericNullNotIndexed(new Long[]{3L, 4L});
        this.withoutNull.setDates(new Date[]{this.indexedDate});
        this.withNullEntry = this.persistEntity((Session)this.fullTextSession, "Worf");
        this.withNullEntry.setNullIndexed(new ArrayBridgeTestEntity.Language[]{ArrayBridgeTestEntity.Language.KLINGON, ArrayBridgeTestEntity.Language.ENGLISH, null});
        this.withNullEntry.setNumericNullIndexed(new Integer[]{11, null});
        this.withNullEntry.setNullNotIndexed(new String[]{"WorfValue", null});
        this.withNullEntry.setNumericNullNotIndexed(new Long[]{33L, null});
        this.withNullEntry.setDates(new Date[]{null});
        this.withNullEmbedded = this.persistEntity((Session)this.fullTextSession, "Mime");
        this.withNullEmbedded.setDates(null);
        this.withNullEmbedded.setNumericNullIndexed(null);
        this.withNullEmbedded.setNumericNullNotIndexed(null);
        this.withNullEmbedded.setNullIndexed(null);
        this.withNullEmbedded.setNullNotIndexed(null);
        this.withNullEmbedded.setDates(null);
        tx.commit();
    }

    public void testSearchNullEntry() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("nullIndexed", "NULL_MARKER");
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullEmbedded() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findEmbeddedNullResults("nullIndexed", "EMBEDDED_NULL");
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection", (String)this.withNullEmbedded.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullNumericEmbedded() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findEmbeddedNullResults("embeddedNum", "EMBEDDED_NUMERIC_NULL");
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (String)this.withNullEmbedded.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullNumericEntry() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("numericNullIndexed", "NULL_NUMERIC_MARKER");
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullEntry() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("nullIndexed", (Object)ArrayBridgeTestEntity.Language.KLINGON);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)ArrayBridgeTestEntity.Language.ITALIAN);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)ArrayBridgeTestEntity.Language.ENGLISH);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)2, (int)results.size());
    }

    public void testSearchEntryWhenNullEntryNotIndexed() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("nullNotIndexed", "DaltoValue");
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findResults("nullNotIndexed", "WorfValue");
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullNumeric() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findNumericResults("numericNullIndexed", 1);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findNumericResults("numericNullIndexed", 11);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullNumericEntryWhenNullEntryNotIndexed() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findNumericResults("numericNullNotIndexed", 3L);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findNumericResults("numericNullNotIndexed", 33L);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testDateIndexing() throws Exception {
        List<ArrayBridgeTestEntity> results = this.findResults("dates", this.indexedDate);
        ArrayBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        ArrayBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        ArrayBridgeTest.assertEquals((String)"Wrong result returned from a collection of Date", (String)this.withoutNull.getName(), (String)results.get(0).getName());
    }

    private List<ArrayBridgeTestEntity> findEmbeddedNullResults(String fieldName, Object value) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ArrayBridgeTestEntity.class).get();
        Query query = ((TermMatchingContext)queryBuilder.keyword().onField(fieldName).ignoreAnalyzer()).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeTestEntity.class}).list();
    }

    private List<ArrayBridgeTestEntity> findResults(String fieldName, Object value) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(ArrayBridgeTestEntity.class).get();
        Query query = queryBuilder.keyword().onField(fieldName).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeTestEntity.class}).list();
    }

    private List<ArrayBridgeTestEntity> findNumericResults(String fieldName, Object number) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)number, (Object)number, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{ArrayBridgeTestEntity.class}).list();
    }

    private ArrayBridgeTestEntity persistEntity(Session s, String name) {
        ArrayBridgeTestEntity boy = new ArrayBridgeTestEntity();
        boy.setName(name);
        s.persist((Object)boy);
        return boy;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{ArrayBridgeTestEntity.class};
    }

    private void cleanData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        List locations = this.fullTextSession.createCriteria(ArrayBridgeTestEntity.class).list();
        for (ArrayBridgeTestEntity location : locations) {
            this.fullTextSession.delete((Object)location);
        }
        tx.commit();
        this.fullTextSession.close();
    }

    private boolean indexIsEmpty() {
        int numDocsForeigner = this.countSizeForType(ArrayBridgeTestEntity.class);
        return numDocsForeigner == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countSizeForType(Class<?> type) {
        SearchFactory searchFactory = this.fullTextSession.getSearchFactory();
        int numDocs = -1;
        IndexReader locationIndexReader = searchFactory.getIndexReaderAccessor().open(new Class[]{type});
        try {
            numDocs = locationIndexReader.numDocs();
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(locationIndexReader);
        }
        return numDocs;
    }
}

