/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.Serializable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.search.Search;
import org.hibernate.search.test.AlternateDocument;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;

public class RamDirectoryTest
extends SearchTestCase {
    public void testMultipleEntitiesPerIndex() throws Exception {
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        Document document = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
        s.persist((Object)document);
        s.flush();
        s.persist((Object)new AlternateDocument(document.getId(), "Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        RamDirectoryTest.assertEquals((int)2, (int)this.getDocumentNbr());
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        TermQuery q = new TermQuery(new Term("alt_title", "hibernate"));
        RamDirectoryTest.assertEquals((String)"does not properly filter", (int)0, (int)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class}).list().size());
        RamDirectoryTest.assertEquals((String)"does not properly filter", (int)1, (int)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class, AlternateDocument.class}).list().size());
        s.delete(s.get(AlternateDocument.class, (Serializable)document.getId()));
        s.getTransaction().commit();
        s.close();
        RamDirectoryTest.assertEquals((int)1, (int)this.getDocumentNbr());
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbr() throws Exception {
        IndexReader reader = IndexReader.open((Directory)this.getDirectory(Document.class), (boolean)true);
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, AlternateDocument.class};
    }
}

