/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;

public class CoordinatesPairFieldBridge
implements TwoWayFieldBridge {
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        String[] coordinates = value.toString().split(";");
        Double x = Double.parseDouble(coordinates[0]);
        Double y = Double.parseDouble(coordinates[1]);
        luceneOptions.addNumericFieldToDocument(this.getXFieldName(name), (Object)x, document);
        luceneOptions.addNumericFieldToDocument(this.getYFieldName(name), (Object)y, document);
    }

    public Object get(String name, Document document) {
        StringBuilder sb = new StringBuilder(7);
        Fieldable xFieldable = document.getFieldable(this.getXFieldName(name));
        Fieldable yFieldable = document.getFieldable(this.getYFieldName(name));
        this.appendValue(xFieldable, sb);
        sb.append(';');
        this.appendValue(yFieldable, sb);
        return sb.toString();
    }

    private void appendValue(Fieldable field, StringBuilder sb) {
        if (field != null) {
            sb.append(field.stringValue());
        } else {
            sb.append('0');
        }
    }

    public String objectToString(Object object) {
        return object.toString();
    }

    private String getYFieldName(String name) {
        return name + "_y";
    }

    private String getXFieldName(String name) {
        return name + "_x";
    }
}

