/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.builtin.CalendarBridge;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.Cloud;
import org.hibernate.search.test.bridge.CloudType;
import org.hibernate.search.test.bridge.IncorrectGet;
import org.hibernate.search.test.bridge.IncorrectObjectToString;
import org.hibernate.search.test.bridge.IncorrectSet;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class BridgeTest
extends SearchTestBase {
    @Test
    public void testDefaultAndNullBridges() throws Exception {
        Cloud cloud = new Cloud();
        cloud.setMyDate(null);
        cloud.setDouble1(null);
        cloud.setDouble2(2.1);
        cloud.setIntegerv1(null);
        cloud.setIntegerv2(2);
        cloud.setFloat1(null);
        cloud.setFloat2(2.1f);
        cloud.setLong1(null);
        cloud.setLong2(2L);
        cloud.setString(null);
        cloud.setType(CloudType.DOG);
        cloud.setChar1(null);
        cloud.setChar2('P');
        cloud.setStorm(false);
        cloud.setClazz(Cloud.class);
        cloud.setUri(new URI("http://www.hibernate.org"));
        cloud.setUrl(new URL("http://www.hibernate.org"));
        cloud.setUuid(UUID.fromString("f49c6ba8-8d7f-417a-a255-d594dddf729f"));
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
        Query query = parser.parse("double2:[2.1 TO 2.1] AND float2:[2.1 TO 2.1] AND integerv2:[2 TO 2.1] AND long2:[2 TO 2.1] AND type:\"dog\" AND storm:false");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"find primitives and do not fail on null", (long)1L, (long)result.size());
        query = parser.parse("double1:[2.1 TO 2.1] OR float1:[2.1 TO 2.1] OR integerv1:[2 TO 2.1] OR long1:[2 TO 2.1]");
        result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"null elements should not be stored", (long)0L, (long)result.size());
        query = parser.parse("type:dog");
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"type"}).list();
        Assert.assertEquals((String)"Enum projection works", (long)1L, (long)result.size());
        query = new TermQuery(new Term("clazz", Cloud.class.getName()));
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"clazz"}).list();
        Assert.assertEquals((String)"Clazz projection works", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Clazz projection works", (Object)Cloud.class.getName(), (Object)((Class)((Object[])result.get(0))[0]).getName());
        BooleanQuery bQuery = new BooleanQuery();
        bQuery.add((Query)new TermQuery(new Term("uri", "http://www.hibernate.org")), BooleanClause.Occur.MUST);
        bQuery.add((Query)new TermQuery(new Term("url", "http://www.hibernate.org")), BooleanClause.Occur.MUST);
        result = session.createFullTextQuery((Query)bQuery, new Class[0]).setProjection(new String[]{"clazz"}).list();
        Assert.assertEquals((String)"Clazz projection works", (long)1L, (long)result.size());
        bQuery = new BooleanQuery();
        bQuery.add((Query)new TermQuery(new Term("uuid", "f49c6ba8-8d7f-417a-a255-d594dddf729f")), BooleanClause.Occur.MUST);
        result = session.createFullTextQuery((Query)bQuery, new Class[0]).setProjection(new String[]{"clazz"}).list();
        Assert.assertEquals((String)"Clazz projection works", (long)1L, (long)result.size());
        query = parser.parse("char1:[" + String.valueOf('\u0000') + " TO " + String.valueOf('\uffff') + "]");
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"char1"}).list();
        Assert.assertEquals((String)"Null elements should not be stored, CharacterBridge is not working", (long)0L, (long)result.size());
        query = parser.parse("char2:P");
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"char2"}).list();
        Assert.assertEquals((String)"Wrong results number, CharacterBridge is not working", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Wrong result, CharacterBridge is not working", (Object)Character.valueOf('P'), (Object)((Object[])result.get(0))[0]);
        s.delete(s.get(Cloud.class, (Serializable)Integer.valueOf(cloud.getId())));
        tx.commit();
        s.close();
    }

    @Test
    public void testCustomBridges() throws Exception {
        Cloud cloud = new Cloud();
        cloud.setCustomFieldBridge("This is divided by 2");
        cloud.setCustomStringBridge("This is div by 4");
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.simpleAnalyzer);
        Query query = parser.parse("customFieldBridge:This AND customStringBridge:This");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"Properties not mapped", (long)1L, (long)result.size());
        query = parser.parse("customFieldBridge:by AND customStringBridge:is");
        result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"Custom types not taken into account", (long)0L, (long)result.size());
        s.delete(s.get(Cloud.class, (Serializable)Integer.valueOf(cloud.getId())));
        tx.commit();
        s.close();
    }

    @Test
    public void testDateBridge() throws Exception {
        Cloud cloud = new Cloud();
        Calendar c = GregorianCalendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(2000, 11, 15, 3, 43, 2);
        c.set(14, 5);
        Date date = new Date(c.getTimeInMillis());
        cloud.setMyDate(date);
        cloud.setDateDay(date);
        cloud.setDateHour(date);
        cloud.setDateMillisecond(date);
        cloud.setDateMinute(date);
        cloud.setDateMonth(date);
        cloud.setDateSecond(date);
        cloud.setDateYear(date);
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
        Query query = parser.parse("myDate:[19900101 TO 20060101] AND dateDay:[20001214 TO 2000121501] AND dateMonth:[200012 TO 20001201] AND dateYear:[2000 TO 200001] AND dateHour:[20001214 TO 2000121503] AND dateMinute:[20001214 TO 200012150343] AND dateSecond:[20001214 TO 20001215034302] AND dateMillisecond:[20001214 TO 20001215034302005]");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"Date not found or not property truncated", (long)1L, (long)result.size());
        s.delete(s.get(Cloud.class, (Serializable)Integer.valueOf(cloud.getId())));
        tx.commit();
        s.close();
    }

    @Test
    public void testCalendarBridge() throws Exception {
        Cloud cloud = new Cloud();
        Calendar c = GregorianCalendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(2000, 11, 15, 3, 43, 2);
        c.set(14, 5);
        cloud.setMyCalendar(c);
        cloud.setCalendarDay(c);
        cloud.setCalendarHour(c);
        cloud.setCalendarMillisecond(c);
        cloud.setCalendarMinute(c);
        cloud.setCalendarMonth(c);
        cloud.setCalendarSecond(c);
        cloud.setCalendarYear(c);
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
        Query query = parser.parse("myCalendar:[19900101 TO 20060101] AND calendarDay:[20001214 TO 2000121501] AND calendarMonth:[200012 TO 20001201] AND calendarYear:[2000 TO 200001] AND calendarHour:[20001214 TO 2000121503] AND calendarMinute:[20001214 TO 200012150343] AND calendarSecond:[20001214 TO 20001215034302] AND calendarMillisecond:[20001214 TO 20001215034302005]");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"Calendar not found or not property truncated", (long)1L, (long)result.size());
        s.delete(s.get(Cloud.class, (Serializable)Integer.valueOf(cloud.getId())));
        tx.commit();
        s.close();
        CalendarBridge bridge = new CalendarBridge();
        HashMap<String, String> bridgeParams = new HashMap<String, String>();
        bridgeParams.put("resolution", Resolution.YEAR.toString());
        bridge.setParameterValues(bridgeParams);
        Assert.assertEquals((Object)"2000", (Object)bridge.objectToString((Object)c));
        bridgeParams.put("resolution", Resolution.DAY.toString());
        bridge.setParameterValues(bridgeParams);
        Assert.assertEquals((Object)"20001215", (Object)bridge.objectToString((Object)c));
    }

    @Test
    public void testIncorrectSetBridge() throws Exception {
        IncorrectSet incorrect = new IncorrectSet();
        incorrect.setSubIncorrect(new IncorrectSet.SubIncorrect());
        incorrect.getSubIncorrect().setName("This is a name not a class");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        try {
            s.persist((Object)incorrect);
            s.flush();
            s.flushToIndexes();
            Assert.fail((String)"Incorrect bridge should fail");
        }
        catch (BridgeException e) {
            tx.rollback();
        }
        catch (HibernateException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BridgeException) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("class: " + IncorrectSet.class.getName()));
                Assert.assertTrue((boolean)throwable.getMessage().contains("path: subIncorrect.name"));
                tx.rollback();
            } else {
                e.printStackTrace();
                Assert.fail((String)("Incorrect bridge should raise a SearchException: " + e.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Incorrect bridge should raise a SearchException");
        }
        s.close();
    }

    @Test
    public void testIncorrectGetBridge() throws Exception {
        IncorrectGet incorrect = new IncorrectGet();
        incorrect.setSubIncorrect(new IncorrectGet.SubIncorrect());
        incorrect.getSubIncorrect().setName("This is a name not a class");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)incorrect);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryBuilder builder = s.getSearchFactory().buildQueryBuilder().forEntity(IncorrectGet.class).get();
        Query query = builder.keyword().onField("subIncorrect.name").matching((Object)"name").createQuery();
        try {
            FullTextQuery textQuery = s.createFullTextQuery(query, new Class[]{IncorrectGet.class}).setProjection(new String[]{"subIncorrect.name"});
            textQuery.list();
            Assert.fail((String)"Incorrect bridge should fail");
        }
        catch (BridgeException e) {
            tx.rollback();
        }
        catch (HibernateException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BridgeException) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("class: " + IncorrectGet.class.getName()));
                Assert.assertTrue((boolean)throwable.getMessage().contains("path: subIncorrect.name"));
                tx.rollback();
            } else {
                e.printStackTrace();
                Assert.fail((String)("Incorrect bridge should raise a SearchException: " + e.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Incorrect bridge should raise a SearchException");
        }
        tx = s.beginTransaction();
        s.delete(s.get(IncorrectGet.class, (Serializable)incorrect.getId()));
        tx.commit();
        s.close();
    }

    @Test
    public void testIncorrectObjectToStringBridge() throws Exception {
        IncorrectObjectToString incorrect = new IncorrectObjectToString();
        incorrect.setName("test");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        try {
            s.persist((Object)incorrect);
            s.flush();
            s.flushToIndexes();
            Assert.fail((String)"Incorrect bridge should fail");
        }
        catch (BridgeException e) {
            tx.rollback();
        }
        catch (HibernateException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BridgeException) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("class: " + IncorrectObjectToString.class.getName()));
                Assert.assertTrue((boolean)throwable.getMessage().contains("path: id"));
                tx.rollback();
            } else {
                e.printStackTrace();
                Assert.fail((String)("Incorrect bridge should raise a SearchException: " + e.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Incorrect bridge should raise a SearchException");
        }
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Cloud.class, IncorrectSet.class, IncorrectGet.class, IncorrectObjectToString.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

