/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.After;
import org.junit.Before;

public abstract class JPATestCase {
    protected EntityManagerFactory factory;

    @Before
    public void setUp() {
        this.factory = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.getConfig());
    }

    @After
    public void tearDown() {
        this.factory.close();
    }

    public abstract Class[] getAnnotatedClasses();

    protected String getPersistenceUnitName() {
        return this.getClass().getSimpleName() + "PU";
    }

    public String[] getEjb3DD() {
        return new String[0];
    }

    public Map<Class, String> getCachedClasses() {
        return new HashMap<Class, String>();
    }

    public Map<String, String> getCachedCollections() {
        return new HashMap<String, String>();
    }

    public static Properties loadProperties() {
        Properties props = new Properties();
        InputStream stream = Persistence.class.getResourceAsStream("/hibernate.properties");
        if (stream != null) {
            try {
                props.load(stream);
            }
            catch (Exception e) {
                throw new RuntimeException("could not load hibernate.properties");
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ioe) {}
            }
        }
        props.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        return props;
    }

    public Map getConfig() {
        Properties config = JPATestCase.loadProperties();
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.addAll(Arrays.asList(this.getAnnotatedClasses()));
        config.put("hibernate.ejb.loaded.classes", classes);
        for (Map.Entry<Class, String> entry : this.getCachedClasses().entrySet()) {
            config.put("hibernate.ejb.classcache." + entry.getKey().getName(), entry.getValue());
        }
        for (Map.Entry<Object, String> entry : this.getCachedCollections().entrySet()) {
            config.put("hibernate.ejb.collectioncache." + (String)entry.getKey(), entry.getValue());
        }
        if (this.getEjb3DD().length > 0) {
            ArrayList<String> dds = new ArrayList<String>();
            dds.addAll(Arrays.asList(this.getEjb3DD()));
            config.put("hibernate.ejb.xml_files", dds);
        }
        config.put("hibernate.search.default.directory_provider", "ram");
        config.put("hibernate.search.analyzer", StopAnalyzer.class.getName());
        config.put("hibernate.ejb.entitymanager_factory_name", "Test" + this.getClass());
        this.configure(config);
        return config;
    }

    public static Version getTargetLuceneVersion() {
        return TestConstants.getTargetLuceneVersion();
    }

    protected void configure(Map cfg) {
    }
}

