/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.facet.Author;
import org.hibernate.search.test.query.facet.Book;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionFacetingTest
extends SearchTestBase {
    Author voltaire;
    Author hugo;
    Author moliere;
    Author proust;

    @Before
    public void createTestData() {
        this.voltaire = new Author();
        this.voltaire.setName("Voltaire");
        this.hugo = new Author();
        this.hugo.setName("Victor Hugo");
        this.moliere = new Author();
        this.moliere.setName("Moliere");
        this.proust = new Author();
        this.proust.setName("Proust");
        Book book1 = new Book();
        book1.setName("Candide");
        book1.getAuthors().add(this.hugo);
        book1.getAuthors().add(this.voltaire);
        Book book2 = new Book();
        book2.setName("Amphitryon");
        book2.getAuthors().add(this.hugo);
        book2.getAuthors().add(this.moliere);
        Book book3 = new Book();
        book3.setName("Hernani");
        book3.getAuthors().add(this.hugo);
        book3.getAuthors().add(this.moliere);
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        session.persist((Object)this.voltaire);
        session.persist((Object)this.hugo);
        session.persist((Object)this.moliere);
        session.persist((Object)this.proust);
        session.persist((Object)book1);
        session.persist((Object)book2);
        session.persist((Object)book3);
        tx.commit();
        session.close();
    }

    @Test
    public void testFacetEmbeddedAndCollections() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Book.class});
        QueryBuilder builder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Book.class).get();
        FacetingRequest facetReq = builder.facet().name("someFacet").onField("authors.name_untokenized").discrete().orderedBy(FacetSortOrder.COUNT_DESC).includeZeroCounts(false).maxFacetCount(10).createFacetingRequest();
        List facets = fullTextQuery.getFacetManager().enableFaceting(facetReq).getFacets("someFacet");
        Assert.assertEquals((String)"There should be three facets", (long)3L, (long)facets.size());
        this.assertFacet((Facet)facets.get(0), this.hugo, 3);
        this.assertFacet((Facet)facets.get(1), this.moliere, 2);
        this.assertFacet((Facet)facets.get(2), this.voltaire, 1);
        fullTextSession.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Author.class, Book.class};
    }

    private void assertFacet(Facet facet, Author expectedAuthor, int expectedCount) {
        Assert.assertEquals((String)"Wrong facet value", (Object)expectedAuthor.getName(), (Object)facet.getValue());
        Assert.assertEquals((String)"Wrong facet count", (long)expectedCount, (long)facet.getCount());
    }
}

