/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import org.apache.lucene.queryparser.classic.QueryParser;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class OptimizeTest
extends SearchTestBase {
    @Test
    public void testOptimize() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 2000;
        for (int i = 0; i < loop; ++i) {
            Email email = new Email();
            email.setId((long)i + 1L);
            email.setTitle("JBoss World Berlin");
            email.setBody("Meet the guys who wrote the software");
            s.persist((Object)email);
        }
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        s.getSearchFactory().optimize(Email.class);
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        int result = s.createFullTextQuery(parser.parse("body:wrote"), new Class[0]).getResultSize();
        Assert.assertEquals((long)2000L, (long)result);
        s.createQuery("delete " + Email.class.getName()).executeUpdate();
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Domain.class};
    }
}

