/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.search.cfg.impl.SearchConfigurationFromHibernateCore;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.DefaultHibernateSessionFactoryService;
import org.hibernate.search.hcore.impl.JMXHook;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.search.hcore.spi.EnvironmentSynchronizer;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.util.impl.Closer;

public class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    private final ConfigurationService configurationService;
    private final JndiService namingService;
    private final ClassLoaderService classLoaderService;
    private final EnvironmentSynchronizer environmentSynchronizer;
    private final ManagedBeanRegistry managedBeanRegistry;
    private final FullTextIndexEventListener listener;
    private final Metadata metadata;
    private final CompletableFuture<ExtendedSearchIntegrator> extendedSearchIntegratorFuture = new CompletableFuture();
    private final CompletableFuture<?> extendedSearchIntegratorClosingTrigger = new CompletableFuture();
    private JMXHook jmx;

    public HibernateSearchSessionFactoryObserver(Metadata metadata, ConfigurationService configurationService, FullTextIndexEventListener listener, ClassLoaderService classLoaderService, EnvironmentSynchronizer environmentSynchronizer, ManagedBeanRegistry managedBeanRegistry, JndiService namingService) {
        this.metadata = metadata;
        this.configurationService = configurationService;
        this.listener = listener;
        this.classLoaderService = classLoaderService;
        this.environmentSynchronizer = environmentSynchronizer;
        this.managedBeanRegistry = managedBeanRegistry;
        this.namingService = namingService;
        this.extendedSearchIntegratorFuture.thenAcceptBoth(this.extendedSearchIntegratorClosingTrigger, (integrator, ignored) -> this.cleanup((ExtendedSearchIntegrator)integrator));
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        boolean failedBootScheduling = true;
        try {
            this.listener.initialize(this.extendedSearchIntegratorFuture);
            if (this.environmentSynchronizer != null) {
                this.environmentSynchronizer.whenEnvironmentDestroying(() -> this.extendedSearchIntegratorClosingTrigger.complete(null));
                this.environmentSynchronizer.whenEnvironmentReady(() -> {
                    try {
                        this.boot(factory);
                    }
                    catch (RuntimeException e) {
                        factory.close();
                    }
                });
            } else {
                this.boot(factory);
            }
            failedBootScheduling = false;
        }
        finally {
            if (failedBootScheduling) {
                this.cancelBoot();
            }
        }
    }

    private synchronized void boot(SessionFactory factory) {
        if (this.extendedSearchIntegratorFuture.isDone()) {
            return;
        }
        try {
            DefaultHibernateSessionFactoryService sessionService = new DefaultHibernateSessionFactoryService(factory);
            SearchIntegrator searchIntegrator = new SearchIntegratorBuilder().configuration((SearchConfiguration)new SearchConfigurationFromHibernateCore(this.metadata, this.configurationService, this.classLoaderService, this.managedBeanRegistry, sessionService, this.namingService)).buildSearchIntegrator();
            ExtendedSearchIntegrator extendedIntegrator = (ExtendedSearchIntegrator)searchIntegrator.unwrap(ExtendedSearchIntegrator.class);
            this.jmx = new JMXHook(this.configurationService);
            this.jmx.registerIfEnabled(extendedIntegrator, factory);
            this.extendedSearchIntegratorFuture.complete(extendedIntegrator);
            SessionFactoryImplementor factoryImplementor = (SessionFactoryImplementor)factory;
            ((SearchFactoryReference)factoryImplementor.getServiceRegistry().getService(SearchFactoryReference.class)).initialize(extendedIntegrator);
        }
        catch (Throwable t) {
            this.extendedSearchIntegratorFuture.completeExceptionally(t);
            throw t;
        }
    }

    public synchronized void sessionFactoryClosing(SessionFactory factory) {
        this.cancelBoot();
    }

    private synchronized void cancelBoot() {
        this.extendedSearchIntegratorFuture.cancel(false);
    }

    public void sessionFactoryClosed(SessionFactory factory) {
        this.extendedSearchIntegratorClosingTrigger.complete(null);
    }

    private synchronized void cleanup(ExtendedSearchIntegrator extendedIntegrator) {
        try (Closer closer = new Closer();){
            if (extendedIntegrator != null) {
                closer.push(() -> ((ExtendedSearchIntegrator)extendedIntegrator).close());
            }
            if (this.jmx != null) {
                closer.push(this.jmx::unRegisterIfRegistered);
                this.jmx = null;
            }
        }
    }

    static {
        Version.touch();
    }
}

