/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.query.facet.CompanyFacility;

@Entity
@Indexed
public class Company {
    @Id
    @GeneratedValue
    private int id;
    private String companyName;
    @IndexedEmbedded
    @OneToMany(cascade={CascadeType.ALL})
    private Set<CompanyFacility> companyFacilities = new HashSet<CompanyFacility>();

    public Company() {
    }

    public Company(String companyName) {
        this.companyName = companyName;
    }

    public int getId() {
        return this.id;
    }

    public String getMake() {
        return this.companyName;
    }

    public void addCompanyFacility(CompanyFacility companyFacility) {
        this.companyFacilities.add(companyFacility);
    }

    public String toString() {
        return "Company{id=" + this.id + ", companyName='" + this.companyName + '\'' + ", companyFacilities=" + this.companyFacilities + '}';
    }
}

