/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.testsupport.concurrency.Poller;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.testing.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-655")
public class MassIndexerCancellingTest
extends SearchTestBase {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());

    @Test
    public void testMassIndexerCancel() throws InterruptedException {
        FullTextSession fullTextSession = MassIndexerCancellingTest.prepareSomeData(this);
        InnerIndexerProgressMonitor monitor = new InnerIndexerProgressMonitor();
        int threadsToLoadObjects = 2;
        Future task = fullTextSession.createIndexer(new Class[]{Book.class}).threadsToLoadObjects(threadsToLoadObjects).batchSizeToLoadObjects(1).progressMonitor((MassIndexerProgressMonitor)monitor).purgeAllOnStart(true).optimizeOnFinish(false).start();
        monitor.waitUntilBusyThreads(threadsToLoadObjects);
        task.cancel(true);
        monitor.waitUntilBusyThreads(0);
        fullTextSession.close();
        Assert.assertTrue((monitor.getThreadNumber() == threadsToLoadObjects ? 1 : 0) != 0);
        Poller.milliseconds((long)10000L, (long)10L).pollAssertion(() -> Assert.assertEquals((String)"Expected index size still not reached after 10 seconds!", (long)2L, (long)this.getIndexSize()));
        Assert.assertTrue((boolean)monitor.massIndexerThreadsAreInterruptedOrDied());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIndexSize() {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            MatchAllDocsQuery q = new MatchAllDocsQuery();
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[]{Book.class});
            int resultSize = fullTextQuery.getResultSize();
            transaction.commit();
            int n = resultSize;
            return n;
        }
    }

    static FullTextSession prepareSomeData(SearchTestBase testCase) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)testCase.openSession());
        fullTextSession.beginTransaction();
        Nation france = new Nation("France", "FR");
        fullTextSession.save((Object)france);
        Book ceylonBook = new Book();
        ceylonBook.setTitle("Ceylon in Action");
        ceylonBook.setFirstPublishedIn(france);
        fullTextSession.save((Object)ceylonBook);
        Book hsBook = new Book();
        hsBook.setTitle("HibernateSearch in Action");
        hsBook.setFirstPublishedIn(france);
        fullTextSession.save((Object)hsBook);
        Book thirdBook = new Book();
        thirdBook.setTitle("Le chateau de ma m\u00e8re");
        thirdBook.setFirstPublishedIn(france);
        fullTextSession.save((Object)thirdBook);
        Book fourthBook = new Book();
        fourthBook.setTitle("La gloire de mon p\u00e8re");
        fourthBook.setFirstPublishedIn(france);
        fullTextSession.save((Object)fourthBook);
        fullTextSession.getTransaction().commit();
        return fullTextSession;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Nation.class};
    }

    class InnerIndexerProgressMonitor
    extends SimpleIndexingProgressMonitor {
        public final List<Thread> threads = Collections.synchronizedList(new ArrayList());
        private final AtomicInteger busyThreads = new AtomicInteger();

        public void documentsBuilt(int number) {
            super.documentsBuilt(number);
            log.debug((Object)("enlist EntityLoader thread [" + Thread.currentThread() + "] and simulate document producer activity"));
            this.threads.add(Thread.currentThread());
            this.busyThreads.incrementAndGet();
            while (!Thread.currentThread().isInterrupted()) {
            }
            log.tracef("Indexing thread is interrupted : end activity simulation ", new Object[0]);
            this.busyThreads.decrementAndGet();
        }

        void waitUntilBusyThreads(int expectedNumberBusyThreads) {
            while (this.busyThreads.get() != expectedNumberBusyThreads) {
                Thread.yield();
            }
        }

        public boolean massIndexerThreadsAreInterruptedOrDied() {
            for (Thread th : this.threads) {
                if (!th.isAlive() || th.isInterrupted()) continue;
                log.tracef("Thread [" + th + "] is not interrupted or alive", new Object[0]);
                return false;
            }
            return true;
        }

        public int getThreadNumber() {
            return this.threads.size();
        }
    }
}

