/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.util.Map;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Nation;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class MassIndexerErrorReportingTest
extends SearchTestBase {
    @Test
    @BMRule(targetClass="org.hibernate.search.batchindexing.impl.IdentifierConsumerDocumentProducer", targetMethod="loadList", action="throw new NullPointerException(\"Byteman created NPE\")", name="testMassIndexerErrorsReported")
    public void testMassIndexerErrorsReported() throws InterruptedException {
        ExtendedSearchIntegrator integrator = this.getExtendedSearchIntegrator();
        MockErrorHandler mockErrorHandler = MassIndexerErrorReportingTest.getErrorHandler((SearchIntegrator)integrator);
        FullTextSession fullTextSession = MassIndexerErrorReportingTest.prepareSomeData(this);
        fullTextSession.createIndexer(new Class[]{Book.class}).startAndWait();
        this.getSession().close();
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertEquals((Object)"HSEARCH000212: An exception occurred while the MassIndexer was transforming identifiers to Lucene Documents", (Object)errorMessage);
        Throwable exception = mockErrorHandler.getLastException();
        Assert.assertTrue((boolean)(exception instanceof NullPointerException));
        Assert.assertEquals((Object)"Byteman created NPE", (Object)exception.getMessage());
    }

    static MockErrorHandler getErrorHandler(SearchIntegrator integrator) {
        ErrorHandler errorHandler = integrator.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        MockErrorHandler mockErrorHandler = (MockErrorHandler)errorHandler;
        return mockErrorHandler;
    }

    static FullTextSession prepareSomeData(SearchTestBase testCase) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)testCase.openSession());
        fullTextSession.beginTransaction();
        Nation france = new Nation("France", "FR");
        fullTextSession.save((Object)france);
        Book ceylonBook = new Book();
        ceylonBook.setTitle("Ceylon in Action");
        ceylonBook.setFirstPublishedIn(france);
        fullTextSession.save((Object)ceylonBook);
        fullTextSession.getTransaction().commit();
        return fullTextSession;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Nation.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

