/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.assertj.core.api.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.batchindexing.LegacyCar;
import org.hibernate.search.test.batchindexing.LegacyCarPlant;
import org.hibernate.search.test.batchindexing.LegacyTire;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Rule;
import org.junit.Test;

public class SimpleIndexingProgressMonitorTest
extends SearchTestBase {
    private static final int NUMBER_OF_CARS = 150;
    private static final int MASS_INDEXING_MONITOR_LOG_PERIOD = 50;
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();

    @Test
    @TestForIssue(jiraKey="HSEARCH-3462")
    public void testLoggedMessages() throws InterruptedException {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            SimpleIndexingProgressMonitorTest.initializeData(fullTextSession);
            MassIndexer indexer = fullTextSession.createIndexer(new Class[0]);
            int batchSize = 49;
            indexer.batchSizeToLoadObjects(batchSize);
            int expectedNumberOfLogs = 3;
            this.logged.expectMessage("documents indexed in").times(expectedNumberOfLogs);
            this.logged.expectMessage("Indexing speed: ").times(expectedNumberOfLogs);
            indexer.startAndWait();
        }
        this.checkEverythingIsIndexed();
    }

    private void checkEverythingIsIndexed() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            int resultSize = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{LegacyCar.class}).getResultSize();
            Assertions.assertThat((int)resultSize).isEqualTo(150);
        }
    }

    private static void initializeData(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        LegacyCar[] cars = new LegacyCar[150];
        for (int i = 0; i < cars.length; ++i) {
            cars[i] = new LegacyCar();
            cars[i].setId("" + i);
            cars[i].setModel("model" + i);
            fullTextSession.persist((Object)cars[i]);
        }
        transaction.commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{LegacyCarPlant.class, LegacyCar.class, LegacyTire.class};
    }
}

