/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import org.apache.lucene.search.Query;
import org.assertj.core.api.Assertions;
import org.hibernate.Session;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Before;
import org.junit.Test;

public class OrmFilterTest
extends SearchTestBase {
    @Test
    public void jpaQuery() {
        try (Session session = this.openSession();){
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery criteria = cb.createQuery(FilterableEntity.class);
            Root root = criteria.from(FilterableEntity.class);
            criteria.where((Expression)cb.like((Expression)root.get("textValue"), "%foo%"));
            criteria.orderBy(new Order[]{cb.asc((Expression)root.get("id"))});
            org.hibernate.query.Query query = session.createQuery(criteria);
            query.setMaxResults(3);
            Assertions.assertThat((List)query.getResultList()).extracting("id").containsExactly(new Object[]{0, 2, 3});
            session.enableFilter("filter1").setParameter("excludedNumericValue", (Object)3);
            Assertions.assertThat((List)query.getResultList()).extracting("id").containsExactly(new Object[]{0, 2, 4});
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2842")
    public void fullTextQuery() {
        try (Session session = this.openSession();
             FullTextSession fullTextSession = Search.getFullTextSession((Session)session);){
            QueryBuilder qb = this.getSearchFactory().buildQueryBuilder().forEntity(FilterableEntity.class).get();
            Query query = qb.keyword().onField("textValue").matching((Object)"foo").createQuery();
            FullTextQuery ftQuery = fullTextSession.createFullTextQuery(query, new Class[]{FilterableEntity.class});
            ftQuery.setSort(qb.sort().byField("idSort").createSort());
            ftQuery.setMaxResults(3);
            Assertions.assertThat((int)ftQuery.getResultSize()).isEqualTo(4);
            Assertions.assertThat((List)ftQuery.getResultList()).extracting("id").containsExactly(new Object[]{0, 2, 3});
            fullTextSession.enableFilter("filter1").setParameter("excludedNumericValue", (Object)3);
            Assertions.assertThat((int)ftQuery.getResultSize()).isEqualTo(4);
            Assertions.assertThat((List)ftQuery.getResultList()).extracting("id").containsExactly(new Object[]{0, 2});
        }
    }

    @Before
    public void createData() {
        try (Session s = this.openSession();){
            s.getTransaction().begin();
            s.persist((Object)new FilterableEntity(0, "foo", 0));
            s.persist((Object)new FilterableEntity(1, "bar", 1));
            s.persist((Object)new FilterableEntity(2, "foo bar", 2));
            s.persist((Object)new FilterableEntity(3, "foo bar", 3));
            s.persist((Object)new FilterableEntity(4, "foo bar", 4));
            s.getTransaction().commit();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{FilterableEntity.class};
    }

    @Entity
    @Indexed
    @FilterDef(name="filter1", parameters={@ParamDef(name="excludedNumericValue", type="integer")})
    @Filter(name="filter1", condition="numericValue <> :excludedNumericValue")
    public static class FilterableEntity {
        @Id
        @Field(name="idSort")
        @SortableField(forField="idSort")
        private Integer id;
        @Field
        @Basic
        private String textValue;
        @Basic
        private Integer numericValue;

        protected FilterableEntity() {
        }

        public FilterableEntity(Integer id, String textValue, Integer numericValue) {
            this.id = id;
            this.textValue = textValue;
            this.numericValue = numericValue;
        }

        public Integer getId() {
            return this.id;
        }
    }
}

