/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.SpatialFieldBridgeByHash;

@Entity
@Indexed
@Spatial
public class DoubleIndexedPOI {
    @Id
    @Field(name="idSort")
    @SortableField(forField="idSort")
    Integer id;
    @Field(store=Store.YES)
    String name;
    @Field(store=Store.YES, index=Index.YES)
    String type;
    @Latitude
    @Field(store=Store.YES, index=Index.YES)
    double latitude;
    @Longitude
    @Field(store=Store.YES, index=Index.YES)
    double longitude;

    @Field(store=Store.YES, index=Index.YES, analyze=Analyze.NO)
    @FieldBridge(impl=SpatialFieldBridgeByHash.class)
    @Embedded
    public Coordinates getLocation() {
        return new Coordinates(){

            public Double getLatitude() {
                return DoubleIndexedPOI.this.latitude;
            }

            public Double getLongitude() {
                return DoubleIndexedPOI.this.longitude;
            }
        };
    }

    public DoubleIndexedPOI(Integer id, String name, double latitude, double longitude, String type) {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.type = type;
    }

    public DoubleIndexedPOI() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getType() {
        return this.type;
    }
}

