/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import java.io.IOException;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.errorhandling.Foo;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@Category(value={SkipOnElasticsearch.class})
public class ConcurrentMergeErrorHandledTest
extends SearchTestBase {
    @Test
    @BMRule(targetClass="org.apache.lucene.index.ConcurrentMergeScheduler", targetMethod="merge", action="throw new IOException(\"Byteman said: your disk is full!\")", name="testLuceneMergerErrorHandling")
    public void testLuceneMergerErrorHandling() {
        MockErrorHandler mockErrorHandler = this.getErrorHandlerAndAssertCorrectTypeIsUsed();
        this.indexSingleFooInstance();
        String errorMessage = mockErrorHandler.getErrorMessage();
        Assert.assertEquals((Object)"HSEARCH000117: IOException on the IndexWriter", (Object)errorMessage);
        Throwable exception = mockErrorHandler.getLastException();
        Assert.assertTrue((boolean)(exception instanceof IOException));
        Assert.assertEquals((Object)"Byteman said: your disk is full!", (Object)exception.getMessage());
    }

    private void indexSingleFooInstance() {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        session.persist((Object)new Foo());
        transaction.commit();
        session.close();
    }

    private MockErrorHandler getErrorHandlerAndAssertCorrectTypeIsUsed() {
        ExtendedSearchIntegrator integrator = this.getExtendedSearchIntegrator();
        ErrorHandler errorHandler = integrator.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        return (MockErrorHandler)errorHandler;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Foo.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }
}

