/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.jmx.Counter;
import org.hibernate.search.test.jmx.SimpleJNDIHelper;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.osjava.sj.memory.MemoryContext;

public class IndexControlMBeanTest
extends SearchTestBase {
    MBeanServer mbeanServer;
    ObjectName statisticsBeanObjectName;
    ObjectName indexBeanObjectName;

    @Test
    public void testIndexCtrlMBeanRegistered() throws Exception {
        Assert.assertTrue((String)"With the right property set the Search MBean should be registered", (boolean)this.mbeanServer.isRegistered(this.indexBeanObjectName));
    }

    @Test
    public void testAttributesAndOperations() throws Exception {
        MBeanInfo info = this.mbeanServer.getMBeanInfo(this.indexBeanObjectName);
        MBeanAttributeInfo[] attributes = info.getAttributes();
        Assert.assertEquals((String)"Wrong number of attributes", (long)3L, (long)attributes.length);
        HashSet<String> attributeNames = new HashSet<String>();
        attributeNames.add("NumberOfObjectLoadingThreads");
        attributeNames.add("NumberOfFetchingThreads");
        attributeNames.add("BatchSize");
        for (MBeanAttributeInfo attribute : attributes) {
            Assert.assertTrue((boolean)attributeNames.contains(attribute.getName()));
        }
        MBeanOperationInfo[] operations = info.getOperations();
        Assert.assertEquals((String)"Wrong number of operations", (long)3L, (long)operations.length);
        HashSet<String> operationNames = new HashSet<String>();
        operationNames.add("index");
        operationNames.add("purge");
        operationNames.add("optimize");
        for (MBeanOperationInfo operation : operations) {
            Assert.assertTrue((boolean)operationNames.contains(operation.getName()));
        }
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testIndexAndPurge() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Counter counter = new Counter();
        s.save((Object)counter);
        tx.commit();
        s.close();
        this.assertNumberOfIndexedEntities(Counter.class.getName(), 0);
        this.mbeanServer.invoke(this.indexBeanObjectName, "index", new String[]{Counter.class.getName()}, new String[]{String.class.getName()});
        this.assertNumberOfIndexedEntities(Counter.class.getName(), 1);
        this.mbeanServer.invoke(this.indexBeanObjectName, "purge", new String[]{Counter.class.getName()}, new String[]{String.class.getName()});
        this.assertNumberOfIndexedEntities(Counter.class.getName(), 0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.statisticsBeanObjectName = new ObjectName("org.hibernate.search.jmx:type=StatisticsInfoMBean");
        this.indexBeanObjectName = new ObjectName("org.hibernate.search.jmx:type=IndexControlMBean");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.mbeanServer.isRegistered(this.statisticsBeanObjectName)) {
            this.mbeanServer.unregisterMBean(this.statisticsBeanObjectName);
        }
        if (this.mbeanServer.isRegistered(this.indexBeanObjectName)) {
            this.mbeanServer.unregisterMBean(this.indexBeanObjectName);
        }
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        Path simpleJndiDir = SimpleJNDIHelper.makeTestingJndiDirectory(IndexControlMBeanTest.class);
        SimpleJNDIHelper.enableSimpleJndi(cfg, (Path)simpleJndiDir);
        cfg.put("hibernate.session_factory_name", "java:comp/SessionFactory");
        cfg.put("hibernate.jndi.org.osjava.sj.factory", "org.hibernate.search.test.jmx.IndexControlMBeanTest$CustomContextFactory");
        cfg.put("hibernate.search.indexing_strategy", "manual");
        cfg.put("hibernate.search.jmx_enabled", "true");
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Counter.class};
    }

    private void assertNumberOfIndexedEntities(String entity, int count) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Assert.assertEquals((String)"wrong number of indexed entities", (Object)count, (Object)this.mbeanServer.invoke(this.statisticsBeanObjectName, "getNumberOfIndexedEntities", new String[]{entity}, new String[]{String.class.getName()}));
    }

    public static class CloseNoOpMemoryContext
    extends MemoryContext {
        public CloseNoOpMemoryContext(Hashtable env) {
            super(env);
        }

        public void close() {
        }
    }

    public static class CustomContextFactory
    implements InitialContextFactory {
        public Context getInitialContext(Hashtable environment) throws NamingException {
            return new CloseNoOpMemoryContext(environment);
        }
    }
}

