/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.test.query.facet.Fruit;
import org.junit.Assert;
import org.junit.Test;

public class FacetUnknownFieldFailureTest
extends AbstractFacetTest {
    @Test
    public void testUnknownFieldNameThrowsException() {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("foo").onField("foobar").discrete().createFacetingRequest();
        try {
            FullTextQuery query = this.queryHondaWithFacet(request);
            query.getFacetManager().getFacets("foo");
            Assert.fail((String)"The specified field name did not exist. Faceting request should fail");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000268"));
        }
    }

    @Test
    public void testKnownFieldNameNotConfiguredForFacetingThrowsException() {
        FacetingRequest request = this.queryBuilder(Fruit.class).facet().name("foo").onField("name").discrete().createFacetingRequest();
        try {
            FullTextQuery query = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Fruit.class});
            query.getFacetManager().enableFaceting(request);
            Assert.assertEquals((String)"Wrong number of query matches", (long)1L, (long)query.getResultSize());
            query.getFacetManager().getFacets("foo");
            Assert.fail((String)"The specified field name did not exist. Faceting request should fail");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000268"));
        }
    }

    private FullTextQuery queryHondaWithFacet(FacetingRequest request) {
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of query matches", (long)13L, (long)query.getResultSize());
        return query;
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                }
            }
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        Fruit apple = new Fruit("Apple", 3.15);
        session.save((Object)apple);
        tx.commit();
        session.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class, Fruit.class};
    }
}

