/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.integration;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.BytemanHelper;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class HibernateSearchSessionFactoryObserverTest {
    @Rule
    public BytemanHelper.BytemanAccessor byteman = BytemanHelper.createAccessor();

    @Test
    @BMRules(rules={@BMRule(targetClass="org.hibernate.internal.SessionFactoryImpl", targetMethod="close", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()", name="Session close counter"), @BMRule(targetClass="org.hibernate.search.spi.SearchIntegratorBuilder", targetMethod="buildSearchIntegrator", action="throw new java.lang.RuntimeException(\"Byteman created runtime exception\")", name="Factory build prohibitor")})
    public void testSessionFactoryGetsClosedOnSearchFactoryCreationFailure() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        builder.addAnnotatedClass(Foo.class);
        try {
            builder.build();
            Assert.fail((String)"ByteMan should have forced an exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Wrong invocation count", (long)1L, (long)this.byteman.getAndResetInvocationCount());
        }
    }

    @Entity
    @Indexed
    public static class Foo {
        @Id
        private long id;
    }
}

