/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.indexes.IndexReaderAccessor;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.test.TestResourceManager;

public abstract class BackendTestHelper {
    private static final String ELASTIC_SEARCH_TEST_HELPER_CLASS_NAME = "org.hibernate.search.elasticsearch.testutil.ElasticsearchBackendTestHelper";

    protected BackendTestHelper() {
    }

    public static BackendTestHelper getInstance(TestResourceManager resourceManager) {
        BackendTestHelper instance;
        try {
            Class<?> clazz = Class.forName(ELASTIC_SEARCH_TEST_HELPER_CLASS_NAME);
            instance = (BackendTestHelper)clazz.getConstructor(TestResourceManager.class).newInstance(resourceManager);
        }
        catch (Exception e) {
            instance = new LuceneBackendTestHelper(resourceManager);
        }
        return instance;
    }

    public abstract int getNumberOfDocumentsInIndex(IndexedTypeIdentifier var1);

    public abstract int getNumberOfDocumentsInIndex(String var1);

    public abstract int getNumberOfDocumentsInIndexByQuery(String var1, String var2, String var3);

    private static class LuceneBackendTestHelper
    extends BackendTestHelper {
        private final TestResourceManager resourceManager;

        public LuceneBackendTestHelper(TestResourceManager resourceManager) {
            this.resourceManager = resourceManager;
        }

        public Directory getDirectory(IndexedTypeIdentifier entityType) {
            ExtendedSearchIntegrator integrator = this.resourceManager.getExtendedSearchIntegrator();
            Set indexManagers = integrator.getIndexBinding(entityType).getIndexManagerSelector().all();
            DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers.iterator().next();
            return indexManager.getDirectoryProvider().getDirectory();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int getNumberOfDocumentsInIndex(IndexedTypeIdentifier entityType) {
            try (DirectoryReader reader = DirectoryReader.open((Directory)this.getDirectory(entityType));){
                int n = reader.numDocs();
                return n;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public int getNumberOfDocumentsInIndex(String indexName) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int getNumberOfDocumentsInIndexByQuery(String indexName, String fieldName, String value) {
            IndexReaderAccessor indexReaderAccessor = this.resourceManager.getExtendedSearchIntegrator().getIndexReaderAccessor();
            Term term = new Term(fieldName, value);
            WildcardQuery query = value.contains("*") ? new WildcardQuery(term) : new TermQuery(term);
            try (IndexReader reader = indexReaderAccessor.open(new String[]{indexName});){
                IndexSearcher searcher = new IndexSearcher(reader);
                TopDocs topDocs = searcher.search((Query)query, 100);
                int n = topDocs.totalHits;
                return n;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

