/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.search.Search;
import org.hibernate.search.test.AlternateDocument;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Assert;
import org.junit.Test;

public class RamDirectoryTest
extends SearchTestBase {
    @Test
    public void testMultipleEntitiesPerIndex() throws Exception {
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        Document document = new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah");
        s.persist((Object)document);
        s.flush();
        s.persist((Object)new AlternateDocument(document.getId(), "Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        Assert.assertEquals((long)2L, (long)this.getDocumentNbr());
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        TermQuery q = new TermQuery(new Term("alt_title", "hibernate"));
        List hibernateDocuments = Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class}).list();
        Assert.assertEquals((String)"does not properly filter", (long)0L, (long)hibernateDocuments.size());
        Assert.assertEquals((String)"does not properly filter", (long)1L, (long)Search.getFullTextSession((Session)s).createFullTextQuery((Query)q, new Class[]{Document.class, AlternateDocument.class}).list().size());
        s.delete(s.get(AlternateDocument.class, (Serializable)document.getId()));
        s.getTransaction().commit();
        s.close();
        Assert.assertEquals((long)1L, (long)this.getDocumentNbr());
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDocumentNbr() throws Exception {
        try (DirectoryReader reader = DirectoryReader.open((Directory)this.getDirectory(Document.class));){
            int n = reader.numDocs();
            return n;
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, AlternateDocument.class};
    }
}

