/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.filter.impl.CachingWrapperFilter;

public class FieldConstraintFilterFactory {
    private String field;
    private String value;

    @Factory
    public Filter buildFilter() {
        TermQuery q = new TermQuery(new Term(this.field, this.value));
        QueryWrapperFilter filter = new QueryWrapperFilter((Query)q);
        filter = new CachingWrapperFilter((Filter)filter);
        return filter;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Key
    public FilterKey getKey() {
        StandardFilterKey key = new StandardFilterKey();
        key.addParameter((Object)this.field);
        key.addParameter((Object)this.value);
        return key;
    }
}

