/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.interceptor;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.interceptor.Article;
import org.hibernate.search.test.interceptor.Blog;
import org.hibernate.search.test.interceptor.BlogStatus;
import org.hibernate.search.test.interceptor.TotalArticle;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexingActionInterceptorTest
extends SearchTestBase {
    private FullTextSession fullTextSession;
    private Blog blog;
    private Article article;
    TotalArticle totalArticle;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createPersistAndIndexTestData();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (!this.fullTextSession.getTransaction().isActive()) {
            Transaction tx = this.fullTextSession.beginTransaction();
            this.blog = (Blog)this.fullTextSession.get(Blog.class, (Serializable)this.blog.getId());
            this.fullTextSession.delete((Object)this.blog);
            this.blog = (Blog)this.fullTextSession.get(Article.class, (Serializable)this.article.getId());
            this.fullTextSession.delete((Object)this.blog);
            this.blog = (Blog)this.fullTextSession.get(TotalArticle.class, (Serializable)this.totalArticle.getId());
            this.fullTextSession.delete((Object)this.blog);
            tx.commit();
        }
        this.fullTextSession.close();
        super.tearDown();
    }

    @Test
    public void testBlogAndArticleAreNotIndexedInDraftStatus() throws Exception {
        Transaction tx = this.fullTextSession.beginTransaction();
        ((ListAssert)Assertions.assertThat((List)this.getBlogEntriesFor(Blog.class)).as("Blog is explicit intercepted")).hasSize(0);
        ((ListAssert)Assertions.assertThat((List)this.getBlogEntriesFor(Article.class)).as("Article is inherently intercepted")).hasSize(0);
        tx.commit();
    }

    @Test
    public void testTotalArticleIsIndexedInDraftStatus() throws Exception {
        Transaction tx = this.fullTextSession.beginTransaction();
        ((ListAssert)Assertions.assertThat((List)this.getBlogEntriesFor(TotalArticle.class)).as("TotalArticle is explicit not intercepted")).hasSize(1);
        tx.commit();
    }

    @Test
    public void testBlogAndArticleAreIndexedInPublishedStatus() throws Exception {
        this.setAllBlogEntriesToStatus(BlogStatus.PUBLISHED);
        Transaction tx = this.fullTextSession.beginTransaction();
        Assertions.assertThat((List)this.getBlogEntriesFor(Blog.class)).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)this.getBlogEntriesFor(Article.class)).as("Article is inherently intercepted")).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)this.getBlogEntriesFor(TotalArticle.class)).as("TotalArticle is explicit not intercepted")).hasSize(1);
        tx.commit();
    }

    @Test
    public void testBlogAndArticleAreNotIndexedInRemovedStatus() throws Exception {
        this.setAllBlogEntriesToStatus(BlogStatus.REMOVED);
        Transaction tx = this.fullTextSession.beginTransaction();
        Assertions.assertThat((List)this.getBlogEntriesFor(Blog.class)).hasSize(0);
        ((ListAssert)Assertions.assertThat((List)this.getBlogEntriesFor(Article.class)).as("Article is inherently intercepted")).hasSize(0);
        tx.commit();
    }

    @Test
    public void testTotalArticleIsIndexedInRemovedStatus() throws Exception {
        this.setAllBlogEntriesToStatus(BlogStatus.REMOVED);
        Transaction tx = this.fullTextSession.beginTransaction();
        ((ListAssert)Assertions.assertThat((List)this.getBlogEntriesFor(TotalArticle.class)).as("TotalArticle is explicit not intercepted")).hasSize(1);
        tx.commit();
    }

    @Test
    public void testInterceptorWithMassIndexer() throws Exception {
        this.setAllBlogEntriesToStatus(BlogStatus.PUBLISHED);
        List allEntries = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
        Assert.assertEquals((String)"Wrong total number of entries", (long)3L, (long)allEntries.size());
        for (Blog blog : allEntries) {
            Assert.assertTrue((boolean)blog.getStatus().equals((Object)BlogStatus.PUBLISHED));
        }
        Transaction tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.purgeAll(Blog.class);
        this.fullTextSession.purgeAll(Article.class);
        this.fullTextSession.purgeAll(TotalArticle.class);
        tx.commit();
        allEntries = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
        Assert.assertEquals((String)"Wrong total number of entries. Index should be empty after purge.", (long)0L, (long)allEntries.size());
        tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.createIndexer(new Class[0]).batchSizeToLoadObjects(25).threadsToLoadObjects(1).threadsForSubsequentFetching(2).optimizeOnFinish(true).startAndWait();
        tx.commit();
        allEntries = this.fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
        Assert.assertEquals((String)"Wrong total number of entries.", (long)3L, (long)allEntries.size());
    }

    private void createPersistAndIndexTestData() {
        this.blog = new Blog();
        this.blog.setTitle("Hibernate Search now has soft deletes!");
        this.blog.setStatus(BlogStatus.DRAFT);
        this.article = new Article();
        this.article.setTitle("Hibernate Search: detailed description of soft deletes");
        this.article.setStatus(BlogStatus.DRAFT);
        this.totalArticle = new TotalArticle();
        this.totalArticle.setTitle("Hibernate Search: the total truth about soft deletes");
        this.totalArticle.setStatus(BlogStatus.DRAFT);
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.persist((Object)this.blog);
        this.fullTextSession.persist((Object)this.article);
        this.fullTextSession.persist((Object)this.totalArticle);
        tx.commit();
        this.fullTextSession.clear();
    }

    private void setAllBlogEntriesToStatus(BlogStatus status) {
        Transaction tx = this.fullTextSession.beginTransaction();
        this.blog = (Blog)this.fullTextSession.get(Blog.class, (Serializable)this.blog.getId());
        this.blog.setStatus(status);
        this.article = (Article)this.fullTextSession.get(Article.class, (Serializable)this.article.getId());
        this.article.setStatus(status);
        this.totalArticle = (TotalArticle)this.fullTextSession.get(TotalArticle.class, (Serializable)this.totalArticle.getId());
        this.totalArticle.setStatus(status);
        tx.commit();
        this.fullTextSession.clear();
    }

    private List getBlogEntriesFor(Class<?> blogType) {
        TermQuery query = new TermQuery(new Term("_hibernate_class", blogType.getName()));
        return this.fullTextSession.createFullTextQuery((Query)query, new Class[0]).list();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Blog.class, Article.class, TotalArticle.class};
    }
}

