/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.jpa.JPATestCase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ToStringTest
extends JPATestCase {
    FullTextEntityManager entityManager;
    FullTextSession fullTextSession;
    Query luceneQuery;

    @Before
    public void setup() {
        this.entityManager = org.hibernate.search.jpa.Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        Session session = (Session)this.entityManager.unwrap(Session.class);
        this.fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Foo.class).get();
        this.luceneQuery = builder.keyword().onField("fubar").matching((Object)"snafu").createQuery();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1173")
    public void testToStringContainsQueryInformationForSessionUseCase() throws Exception {
        FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(this.luceneQuery, new Class[]{Foo.class});
        this.assertToStringContainsLuceneQueryInformation(fullTextQuery.toString());
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1173")
    public void testToStringContainsQueryInformationForJPAUseCase() throws Exception {
        org.hibernate.search.jpa.FullTextQuery fullTextQuery = this.entityManager.createFullTextQuery(this.luceneQuery, new Class[]{Foo.class});
        this.assertToStringContainsLuceneQueryInformation(fullTextQuery.toString());
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Foo.class};
    }

    private void assertToStringContainsLuceneQueryInformation(String fullTextQueryString) {
        Assert.assertEquals((String)"Unexpected toString implementation. The string should contain Lucene query information", (Object)"FullTextQueryImpl(fubar:snafu)", (Object)fullTextQueryString);
    }

    @Entity
    @Indexed
    public static class Foo {
        @Id
        @GeneratedValue
        private long id;
        @Field
        private String fubar;
    }
}

