/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectArrayAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1947")
public class JavaTimeTest
extends SearchTestBase {
    @After
    public void deleteEntity() {
        try (Session s = this.openSession();){
            Transaction tx = s.beginTransaction();
            s.delete(s.load(Sample.class, (Serializable)Long.valueOf(1L)));
            s.flush();
            tx.commit();
        }
    }

    @Test
    public void testLocalDate() throws Exception {
        LocalDate date = LocalDate.of(2012, Month.DECEMBER, 30);
        Sample sample = new Sample(1L, "LocalDate example");
        sample.localDate = date;
        this.assertThatFieldIsIndexed("localDate", date, sample);
    }

    @Test
    public void testLocalTime() throws Exception {
        LocalTime time = LocalTime.of(13, 15, 55, 7);
        Sample sample = new Sample(1L, "LocalTime example");
        sample.localTime = time;
        this.assertThatFieldIsIndexed("localTime", time, sample);
    }

    @Test
    public void testLocalDateTime() throws Exception {
        LocalDate date = LocalDate.of(1998, Month.FEBRUARY, 12);
        LocalTime time = LocalTime.of(13, 5, 33);
        LocalDateTime dateTime = LocalDateTime.of(date, time);
        Sample sample = new Sample(1L, "LocalDateTime example");
        sample.localDateTime = dateTime;
        this.assertThatFieldIsIndexed("localDateTime", dateTime, sample);
    }

    @Test
    public void testInstant() throws Exception {
        LocalDate date = LocalDate.of(1998, Month.FEBRUARY, 12);
        LocalTime time = LocalTime.of(13, 5, 33, 5000000);
        LocalDateTime dateTime = LocalDateTime.of(date, time);
        Instant instant = dateTime.toInstant(ZoneOffset.UTC);
        Sample sample = new Sample(1L, "Instant example");
        sample.instant = instant;
        this.assertThatFieldIsIndexed("instant", instant, sample);
    }

    @Test
    public void testDuration() throws Exception {
        Duration value = Duration.ofNanos(Long.MAX_VALUE);
        Sample sample = new Sample(1L, "Duration example");
        sample.duration = value;
        this.assertThatFieldIsIndexed("duration", value, sample);
    }

    @Test
    public void testPeriod() throws Exception {
        Period value = Period.ZERO;
        Sample sample = new Sample(1L, "Period example");
        sample.period = value;
        this.assertThatFieldIsIndexed("period", value, sample);
    }

    @Test
    public void testZoneOffset() throws Exception {
        ZoneOffset value = ZoneOffset.MAX;
        Sample sample = new Sample(1L, "zoneOffset example");
        sample.zoneOffset = value;
        this.assertThatFieldIsIndexed("zoneOffset", value, sample);
    }

    @Test
    public void testZoneId() throws Exception {
        ZoneId value = ZoneId.of("GMT");
        Sample sample = new Sample(1L, "ZoneId example");
        sample.zoneId = value;
        this.assertThatFieldIsIndexed("zoneId", value, sample);
    }

    @Test
    public void testOffsetDateTime() throws Exception {
        OffsetDateTime value = OffsetDateTime.MIN;
        Sample sample = new Sample(1L, "OffsetDateTime example");
        sample.offsetDateTime = value;
        this.assertThatFieldIsIndexed("offsetDateTime", value, sample);
    }

    @Test
    public void testOffsetTime() throws Exception {
        OffsetTime value = OffsetTime.MIN;
        Sample sample = new Sample(1L, "OffsetTime example");
        sample.offsetTime = value;
        this.assertThatFieldIsIndexed("offsetTime", value, sample);
    }

    @Test
    public void testYear() throws Exception {
        Year value = Year.of(999999999);
        Sample sample = new Sample(1L, "Year example");
        sample.year = value;
        this.assertThatFieldIsIndexed("year", value, sample);
    }

    @Test
    public void testYearMonth() throws Exception {
        YearMonth value = YearMonth.of(124, 12);
        Sample sample = new Sample(1L, "YearMonth example");
        sample.yearMonth = value;
        this.assertThatFieldIsIndexed("yearMonth", value, sample);
    }

    @Test
    public void testMonthDay() throws Exception {
        MonthDay value = MonthDay.of(12, 1);
        Sample sample = new Sample(1L, "MonthDay example");
        sample.monthDay = value;
        this.assertThatFieldIsIndexed("monthDay", value, sample);
    }

    private void assertThatFieldIsIndexed(String field, Object expectedValue, Sample sample) {
        try (Session s = this.openSession();){
            Transaction tx = s.beginTransaction();
            s.persist((Object)sample);
            s.flush();
            tx.commit();
            tx = s.beginTransaction();
            FullTextSession session = Search.getFullTextSession((Session)s);
            Query query = ((TermMatchingContext)this.queryBuilder(session).keyword().onField(field).ignoreAnalyzer()).matching(expectedValue).createQuery();
            Object[] result = (Object[])session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{field}).uniqueResult();
            ((ObjectArrayAssert)Assertions.assertThat((Object[])result).as("Indexed value for field '" + field + "' not found")).containsOnly(new Object[]{expectedValue});
            tx.commit();
        }
    }

    @Field(analyze=Analyze.NO, store=Store.YES)
    private QueryBuilder queryBuilder(FullTextSession session) {
        QueryBuilder builder = session.getSearchFactory().buildQueryBuilder().forEntity(Sample.class).get();
        return builder;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Sample.class};
    }

    @Entity
    @Indexed
    static class Sample {
        @Id
        @DocumentId
        long id;
        @Field(analyze=Analyze.NO, store=Store.YES)
        String description;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private LocalDate localDate;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private LocalTime localTime;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private LocalDateTime localDateTime;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private Instant instant;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private Duration duration;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private Period period;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private ZoneOffset zoneOffset;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private ZoneId zoneId;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private OffsetDateTime offsetDateTime;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private OffsetTime offsetTime;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private Year year;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private YearMonth yearMonth;
        @Field(analyze=Analyze.NO, store=Store.YES)
        private MonthDay monthDay;

        public Sample() {
        }

        public Sample(long id, String description) {
            this.id = id;
            this.description = description;
        }
    }
}

