/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.query.CalendarDay;
import org.hibernate.search.test.query.CounterCallsProjectionToMapResultTransformer;
import org.hibernate.search.test.query.Employee;
import org.hibernate.search.test.query.FootballTeam;
import org.hibernate.search.test.query.Husband;
import org.hibernate.search.test.query.ProjectionToDelimStringResultTransformer;
import org.hibernate.search.test.query.ProjectionToMapResultTransformer;
import org.hibernate.search.test.query.Spouse;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.readerprovider.FieldSelectorLeakingReaderProvider;
import org.hibernate.transform.ResultTransformer;
import org.junit.Assert;
import org.junit.Test;

public class ProjectionQueryTest
extends SearchTestBase {
    @Test
    public void testProjectionOfThisAndEAGERFetching() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Spouse spouse = new Spouse();
        spouse.setFirstName("Christina");
        s.save((Object)spouse);
        Husband h = new Husband();
        h.setLastName("Roberto");
        h.setSpouse(spouse);
        s.save((Object)h);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryBuilder qb = s.getSearchFactory().buildQueryBuilder().forEntity(Husband.class).get();
        Query query = qb.keyword().onField("lastName").matching((Object)"Roberto").createQuery();
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Husband.class});
        hibQuery.setProjection(new String[]{"__HSearch_This"});
        Criteria fetchingStrategy = s.createCriteria(Husband.class);
        fetchingStrategy.setFetchMode("spouse", FetchMode.JOIN);
        hibQuery.setCriteriaQuery(fetchingStrategy);
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"id"});
        Object[] projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Husband husband = (Husband)projection[0];
        Assert.assertTrue((boolean)Hibernate.isInitialized((Object)husband.getSpouse()));
        for (Object element : s.createQuery("from " + Husband.class.getName()).list()) {
            s.delete(element);
        }
        for (Object element : s.createQuery("from " + Spouse.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testClassProjection() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        hibQuery.setProjection(new String[]{"_hibernate_class"});
        List result = hibQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[0]);
        Assert.assertNotNull((Object)result);
        Object[] projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Assert.assertEquals((String)"Wrong projected class", Employee.class, (Object)projection[0]);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testLuceneObjectsProjectionWithScroll() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept", "__HSearch_This", "__HSearch_Score", "__HSearch_Document", "__HSearch_id"});
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        ScrollableResults projections = hibQuery.scroll();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
        projections.beforeFirst();
        projections.next();
        Object[] projection = projections.get();
        this.checkProjectionFirst(projection, (Session)s);
        Assert.assertTrue((boolean)projections.isFirst());
        projections.last();
        projection = projections.get();
        this.checkProjectionLast(projection, (Session)s);
        Assert.assertTrue((boolean)projections.isLast());
        projections.next();
        projection = projections.get();
        Assert.assertNull((Object)projection);
        projections.previous();
        projection = projections.get();
        this.checkProjectionLast(projection, (Session)s);
        projections.first();
        projection = projections.get();
        this.checkProjectionFirst(projection, (Session)s);
        projections.scroll(2);
        projection = projections.get();
        this.checkProjection2(projection, (Session)s);
        projections.scroll(-5);
        projection = projections.get();
        Assert.assertNull((Object)projection);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testResultTransformToDelimString() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept", "__HSearch_This", "__HSearch_Score", "__HSearch_id"});
        hibQuery.setResultTransformer((ResultTransformer)new ProjectionToDelimStringResultTransformer());
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"lastname", "dept", "id"});
        Assert.assertTrue((String)"incorrect transformation", (boolean)((String)result.get(0)).startsWith("1000, Griffin, ITech"));
        Assert.assertTrue((String)"incorrect transformation", (boolean)((String)result.get(1)).startsWith("1002, Jimenez, ITech"));
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testResultTransformMap() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept", "__HSearch_This", "__HSearch_Score", "__HSearch_Document", "__HSearch_id"});
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        hibQuery.setResultTransformer((ResultTransformer)new ProjectionToMapResultTransformer());
        List transforms = hibQuery.list();
        Map map = (Map)transforms.get(1);
        Assert.assertEquals((String)"incorrect transformation", (Object)"ITech", map.get("dept"));
        Assert.assertEquals((String)"incorrect transformation", (Object)1002, map.get("id"));
        Assert.assertTrue((String)"incorrect transformation", (boolean)(map.get("__HSearch_Document") instanceof Document));
        Assert.assertEquals((String)"incorrect transformation", (Object)"01002", (Object)((Document)map.get("__HSearch_Document")).get("id"));
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testTransformListIsCalled() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept", "__HSearch_This", "__HSearch_Score", "__HSearch_Document", "__HSearch_id"});
        hibQuery.setSort(new Sort(new SortField("id", SortField.Type.STRING)));
        CounterCallsProjectionToMapResultTransformer counters = new CounterCallsProjectionToMapResultTransformer();
        hibQuery.setResultTransformer((ResultTransformer)counters);
        List transforms = hibQuery.list();
        Assert.assertEquals((long)counters.getTransformListCounter(), (long)1L);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    private void checkProjectionFirst(Object[] projection, Session s) {
        Assert.assertEquals((String)"id incorrect", (Object)1000, (Object)projection[0]);
        Assert.assertEquals((String)"lastname incorrect", (Object)"Griffin", (Object)projection[1]);
        Assert.assertEquals((String)"dept incorrect", (Object)"ITech", (Object)projection[2]);
        Assert.assertEquals((String)"THIS incorrect", (Object)projection[3], (Object)s.get(Employee.class, (Serializable)projection[0]));
        Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[4] instanceof Float));
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[5] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)4L, (long)((Document)projection[5]).getFields().size());
        Assert.assertEquals((String)"legacy ID incorrect", (Object)1000, (Object)projection[6]);
    }

    private void checkProjectionLast(Object[] projection, Session s) {
        Assert.assertEquals((String)"id incorrect", (Object)1004, (Object)projection[0]);
        Assert.assertEquals((String)"lastname incorrect", (Object)"Whetbrook", (Object)projection[1]);
        Assert.assertEquals((String)"dept incorrect", (Object)"ITech", (Object)projection[2]);
        Assert.assertEquals((String)"THIS incorrect", (Object)projection[3], (Object)s.get(Employee.class, (Serializable)projection[0]));
        Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[4] instanceof Float));
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[5] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)4L, (long)((Document)projection[5]).getFields().size());
        Assert.assertEquals((String)"legacy ID incorrect", (Object)1004, (Object)projection[6]);
    }

    private void checkProjection2(Object[] projection, Session s) {
        Assert.assertEquals((String)"id incorrect", (Object)1003, (Object)projection[0]);
        Assert.assertEquals((String)"lastname incorrect", (Object)"Stejskal", (Object)projection[1]);
        Assert.assertEquals((String)"dept incorrect", (Object)"ITech", (Object)projection[2]);
        Assert.assertEquals((String)"THIS incorrect", (Object)projection[3], (Object)s.get(Employee.class, (Serializable)projection[0]));
        Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[4] instanceof Float));
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[5] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)4L, (long)((Document)projection[5]).getFields().size());
        Assert.assertEquals((String)"legacy ID incorrect", (Object)1003, (Object)projection[6]);
    }

    @Test
    public void testLuceneObjectsProjectionWithIterate() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept", "__HSearch_This", "__HSearch_Score", "__HSearch_Document", "__HSearch_id"});
        int counter = 0;
        Iterator iter = hibQuery.iterate();
        while (iter.hasNext()) {
            Object[] projection = (Object[])iter.next();
            Assert.assertNotNull((Object)projection);
            ++counter;
            Assert.assertEquals((String)"dept incorrect", (Object)"ITech", (Object)projection[2]);
            Assert.assertEquals((String)"THIS incorrect", (Object)projection[3], (Object)s.get(Employee.class, (Serializable)projection[0]));
            Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[4] instanceof Float));
            Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[5] instanceof Document));
            Assert.assertEquals((String)"DOCUMENT size incorrect", (long)4L, (long)((Document)projection[5]).getFields().size());
        }
        Assert.assertEquals((String)"incorrect number of results returned", (long)4L, (long)counter);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testLuceneObjectsProjectionWithList() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:Accounting");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept", "__HSearch_This", "__HSearch_Score", "__HSearch_Document", "__HSearch_id", "__HSearch_DocumentId"});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Object[] projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Assert.assertEquals((String)"id incorrect", (Object)1001, (Object)projection[0]);
        Assert.assertEquals((String)"last name incorrect", (Object)"Jackson", (Object)projection[1]);
        Assert.assertEquals((String)"dept incorrect", (Object)"Accounting", (Object)projection[2]);
        Assert.assertEquals((String)"THIS incorrect", (Object)"Jackson", (Object)((Employee)projection[3]).getLastname());
        Assert.assertEquals((String)"THIS incorrect", (Object)projection[3], (Object)s.get(Employee.class, (Serializable)projection[0]));
        Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[4] instanceof Float));
        Assert.assertFalse((String)"SCORE should not be a NaN", (boolean)Float.isNaN(((Float)projection[4]).floatValue()));
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[5] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)5L, (long)((Document)projection[5]).getFields().size());
        Assert.assertEquals((String)"ID incorrect", (Object)1001, (Object)projection[6]);
        Assert.assertNotNull((String)"Lucene internal doc id", (Object)projection[7]);
        hibQuery.setProjection(new String[]{"__HSearch_Document", "__HSearch_This", "__HSearch_Score", null, "__HSearch_id", "id", "lastname", "dept", "hireDate", "__HSearch_DocumentId"});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[0] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)5L, (long)((Document)projection[0]).getFields().size());
        Assert.assertEquals((String)"THIS incorrect", (Object)projection[1], (Object)s.get(Employee.class, (Serializable)projection[4]));
        Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[2] instanceof Float));
        Assert.assertNull((String)"BOOST not removed", (Object)projection[3]);
        Assert.assertEquals((String)"ID incorrect", (Object)1001, (Object)projection[4]);
        Assert.assertEquals((String)"id incorrect", (Object)1001, (Object)projection[5]);
        Assert.assertEquals((String)"last name incorrect", (Object)"Jackson", (Object)projection[6]);
        Assert.assertEquals((String)"dept incorrect", (Object)"Accounting", (Object)projection[7]);
        Assert.assertNotNull((String)"Date", (Object)projection[8]);
        Assert.assertNotNull((String)"Lucene internal doc id", (Object)projection[9]);
        hibQuery.setSort(new Sort(new SortField("lastname", SortField.Type.STRING)));
        hibQuery.setProjection(new String[]{"__HSearch_This", "__HSearch_Score"});
        result = hibQuery.list();
        projection = (Object[])result.get(0);
        Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[1] instanceof Float));
        Assert.assertFalse((String)"SCORE should not be a NaN", (boolean)Float.isNaN(((Float)projection[1]).floatValue()));
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testNonLoadedFieldOptmization() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        this.prepEmployeeIndex(s);
        s.clear();
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:Accounting");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"__HSearch_id", "__HSearch_Document"});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Object[] projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Assert.assertEquals((String)"id field name not projected", (Object)1001, (Object)projection[0]);
        Assert.assertEquals((String)"Document fields should not be lazy on DOCUMENT projection", (Object)"Jackson", (Object)((Document)projection[1]).getField("lastname").stringValue());
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)5L, (long)((Document)projection[1]).getFields().size());
        hibQuery.setProjection(new String[]{"__HSearch_This", "__HSearch_Score", null, "lastname"});
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Assert.assertTrue((String)"THIS incorrect", (boolean)(projection[0] instanceof Employee));
        Assert.assertTrue((String)"SCORE incorrect", (boolean)(projection[1] instanceof Float));
        Assert.assertEquals((String)"last name incorrect", (Object)"Jackson", (Object)projection[3]);
        for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testProjectionInNumericFields() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        FootballTeam chelsea = new FootballTeam(1, "Chelsea", 0.5, 4);
        FootballTeam manUtd = new FootballTeam(2, "Manchester United", 700.5, 18);
        FootballTeam liverpool = new FootballTeam(3, "Liverpool", 502.4, 18);
        s.save((Object)manUtd);
        s.save((Object)liverpool);
        s.save((Object)chelsea);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        Query query = NumericFieldUtils.createNumericRangeQuery((String)"debtInMillions", (Object)600.0, (Object)800.0, (boolean)true, (boolean)true);
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{FootballTeam.class});
        hibQuery.setProjection(new String[]{"nrTitles", "name", "debtInMillions"});
        List result = hibQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"nrTitles", "name", "debtInMillions"});
        Assert.assertEquals((long)1L, (long)result.size());
        Object[] projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Assert.assertTrue((String)"Numeric int Field not projected", (boolean)(projection[0] instanceof Integer));
        Assert.assertTrue((String)"String Field not projected", (boolean)(projection[1] instanceof String));
        Assert.assertTrue((String)"Numeric double Field not projected", (boolean)(projection[2] instanceof Double));
        Assert.assertEquals((Object)18, (Object)projection[0]);
        Assert.assertEquals((Object)"Manchester United", (Object)projection[1]);
        Assert.assertEquals((Object)700.5, (Object)projection[2]);
        for (Object element : s.createQuery("from " + FootballTeam.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testProjectionUnmappedFieldValues() throws ParseException, IOException {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)new CalendarDay().setDayFromItalianString("01/04/2011"));
        s.persist((Object)new CalendarDay().setDayFromItalianString("02/04/2011"));
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        FullTextQuery hibQuery = s.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{CalendarDay.class});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        hibQuery.setProjection(new String[]{"day.year"});
        List result = hibQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Wrong number of results", (long)2L, (long)result.size());
        for (Object resultLine : result) {
            Object[] projection = (Object[])resultLine;
            Assert.assertNotNull((Object)projection);
            Assert.assertEquals((String)"Wrong projected result", (Object)"2011", (Object)projection[0]);
        }
        for (Object element : s.createQuery("from " + CalendarDay.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    private void prepEmployeeIndex(FullTextSession s) {
        Transaction tx = s.beginTransaction();
        Employee e1 = new Employee(1000, "Griffin", "ITech");
        s.save((Object)e1);
        Employee e2 = new Employee(1001, "Jackson", "Accounting");
        e2.setHireDate(new Date());
        s.save((Object)e2);
        Employee e3 = new Employee(1002, "Jimenez", "ITech");
        s.save((Object)e3);
        Employee e4 = new Employee(1003, "Stejskal", "ITech");
        s.save((Object)e4);
        Employee e5 = new Employee(1004, "Whetbrook", "ITech");
        s.save((Object)e5);
        tx.commit();
    }

    @Test
    public void testProjection() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        Book book = new Book(1, "La chute de la petite reine a travers les yeux de Festina", "La chute de la petite reine a travers les yeux de Festina, blahblah");
        s.save((Object)book);
        Book book2 = new Book(2, "Sous les fleurs il n'y a rien", null);
        s.save((Object)book2);
        Author emmanuel = new Author();
        emmanuel.setName("Emmanuel");
        s.save((Object)emmanuel);
        book.setMainAuthor(emmanuel);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("title", TestConstants.stopAnalyzer);
        Query query = parser.parse("summary:Festina");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        hibQuery.setProjection(new String[]{"id", "summary", "mainAuthor.name"});
        List result = hibQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"id", "summary", "mainAuthor.name"});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Query with no explicit criteria", (long)1L, (long)result.size());
        Object[] projection = (Object[])result.get(0);
        Assert.assertEquals((String)"id", (Object)1, (Object)projection[0]);
        Assert.assertEquals((String)"summary", (Object)"La chute de la petite reine a travers les yeux de Festina", (Object)projection[1]);
        Assert.assertEquals((String)"mainAuthor.name (embedded objects)", (Object)"Emmanuel", (Object)projection[2]);
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        hibQuery.setProjection(new String[]{"id", "body", "mainAuthor.name"});
        try {
            hibQuery.list();
            Assert.fail((String)"Projecting an unstored field should raise an exception");
        }
        catch (SearchException searchException) {
            // empty catch block
        }
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        hibQuery.setProjection(new String[0]);
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((String)"Should not trigger projection", (boolean)(result.get(0) instanceof Book));
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        hibQuery.setProjection((String[])null);
        result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((String)"Should not trigger projection", (boolean)(result.get(0) instanceof Book));
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"id"});
        query = parser.parse("summary:fleurs");
        hibQuery = s.createFullTextQuery(query, new Class[]{Book.class});
        hibQuery.setProjection(new String[]{"id", "summary", "mainAuthor.name"});
        result = hibQuery.list();
        hibQuery.setProjection(new String[]{"id", "summary", "mainAuthor.name"});
        Assert.assertEquals((long)1L, (long)result.size());
        projection = (Object[])result.get(0);
        Assert.assertEquals((String)"mainAuthor.name", null, (Object)projection[2]);
        for (Object element : s.createQuery("from " + Book.class.getName()).list()) {
            s.delete(element);
        }
        for (Object element : s.createQuery("from " + Author.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, Employee.class, Husband.class, Spouse.class, FootballTeam.class, CalendarDay.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.directory_provider", "ram");
        cfg.put("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName());
    }
}

