/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.ListAssert;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.test.jpa.JPATestCase;
import org.hibernate.search.test.query.ProductArticle;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Test;

public class SortUsingEntityManagerTest
extends JPATestCase {
    private static final TimeZone ENCODING_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final boolean DESC = true;
    private FullTextEntityManager em;
    private QueryParser queryParser;

    @Override
    public void setUp() {
        super.setUp();
        this.em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        this.queryParser = new QueryParser("header", TestConstants.stopAnalyzer);
        this.createArticles();
    }

    private void createArticles() {
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        try {
            this.em.persist((Object)this.article(1, "Hibernate & Lucene", this.date(4, 6, 2005)));
            this.em.persist((Object)this.article(2, "Hibernate Search", this.date(2, 8, 2005)));
            this.em.persist((Object)this.article(3, "Hibernate OGM", this.date(4, 8, 2005)));
            this.em.persist((Object)this.article(4, "Hibernate", this.date(4, 11, 2005)));
            this.em.persist((Object)this.article(5, "Hibernate Validator", this.date(8, 8, 2010)));
            this.em.persist((Object)this.article(6, "Hibernate Core", this.date(4, 8, 2012)));
        }
        finally {
            tx.commit();
            this.em.clear();
        }
    }

    @Test
    public void testResultOrderedByDateDescending() throws Exception {
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        Sort dateDescending = new Sort(new SortField("creationDate", SortField.Type.LONG, true));
        List result = this.query("Hib*").setSort(dateDescending).setFirstResult(3).getResultList();
        ((ListAssert)Assertions.assertThat((List)result).as("query result")).hasSize(3);
        ((IntAssert)Assertions.assertThat((Integer)((ProductArticle)result.get(0)).getArticleId()).as("article id")).isEqualTo(3);
        ((IntAssert)Assertions.assertThat((Integer)((ProductArticle)result.get(1)).getArticleId()).as("article id")).isEqualTo(2);
        ((IntAssert)Assertions.assertThat((Integer)((ProductArticle)result.get(2)).getArticleId()).as("article id")).isEqualTo(1);
        tx.commit();
        this.em.clear();
    }

    private FullTextQuery query(String q) throws ParseException {
        Query query = this.queryParser.parse(q);
        return this.em.createFullTextQuery(query, new Class[]{ProductArticle.class});
    }

    private Date date(int day, int month, int year) {
        Calendar cal = Calendar.getInstance(ENCODING_TIME_ZONE, Locale.US);
        cal.set(year, month, day, 11, 5, 30);
        return cal.getTime();
    }

    private ProductArticle article(int id, String header, Date date) {
        ProductArticle article = new ProductArticle();
        article.setCreationDate(date);
        article.setHeader(header);
        article.setArticleId(id);
        return article;
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{ProductArticle.class};
    }
}

