/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.spatial.DoubleIndexedPOI;
import org.hibernate.search.test.spatial.Event;
import org.hibernate.search.test.spatial.GetterUser;
import org.hibernate.search.test.spatial.Hotel;
import org.hibernate.search.test.spatial.MissingSpatialPOI;
import org.hibernate.search.test.spatial.NonGeoPOI;
import org.hibernate.search.test.spatial.POI;
import org.hibernate.search.test.spatial.RangeEvent;
import org.hibernate.search.test.spatial.RangeHotel;
import org.hibernate.search.test.spatial.Restaurant;
import org.hibernate.search.test.spatial.User;
import org.hibernate.search.test.spatial.UserEx;
import org.hibernate.search.test.spatial.UserRange;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpatialIndexingTest
extends SearchTestBase {
    private FullTextSession fullTextSession;

    @Before
    public void createAndIndexTestData() throws Exception {
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.save((Object)new POI(1, "Distance to 24,32 : 0", 24.0, 32.0, ""));
        this.fullTextSession.save((Object)new POI(2, "Distance to 24,32 : 10.16", 24.0, 31.9, ""));
        this.fullTextSession.save((Object)new POI(3, "Distance to 24,32 : 11.12", 23.9, 32.0, ""));
        this.fullTextSession.save((Object)new POI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, ""));
        this.fullTextSession.save((Object)new POI(5, "Distance to 24,32 : 22.24", 24.2, 32.0, ""));
        this.fullTextSession.save((Object)new POI(6, "Distance to 24,32 : 24.45", 24.2, 31.9, ""));
        this.fullTextSession.save((Object)new NonGeoPOI(1, "Distance to 24,32 : 0", 24.0, null, ""));
        this.fullTextSession.save((Object)new NonGeoPOI(2, "Distance to 24,32 : 24.45", 24.2, 31.9, ""));
        this.fullTextSession.save((Object)new NonGeoPOI(3, "Distance to 24,32 : 10.16", 24.0, 31.9, ""));
        this.fullTextSession.save((Object)new NonGeoPOI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, ""));
        this.fullTextSession.save((Object)new NonGeoPOI(5, "Distance to 24,32 : 11.12", 23.9, 32.0, ""));
        this.fullTextSession.save((Object)new NonGeoPOI(6, "Distance to 24,32 : 22.24", 24.2, 32.0, ""));
        this.fullTextSession.save((Object)new MissingSpatialPOI(1, "Distance to 24,32 : 0", 24.0, 32.0, ""));
        SimpleDateFormat dateFormat = new SimpleDateFormat("d M yyyy", Locale.ROOT);
        Date date = dateFormat.parse("10 9 1976");
        this.fullTextSession.save((Object)new Event(1, "Test", 24.0, 32.0, date));
        this.fullTextSession.save((Object)new User(1, 24.0, 32.0));
        this.fullTextSession.save((Object)new UserRange(1, 24.0, 32.0));
        this.fullTextSession.save((Object)new UserEx(1, 24.0, 32.0, 11.9, 27.4));
        dateFormat = new SimpleDateFormat("d M yyyy", Locale.ROOT);
        date = dateFormat.parse("10 9 1976");
        this.fullTextSession.save((Object)new RangeEvent(1, "Test", 24.0, 32.0, date));
        this.fullTextSession.save((Object)new Hotel(1, "Plazza Ath\u00e9n\u00e9e", 24.0, 32.0, "Luxurious"));
        this.fullTextSession.save((Object)new RangeHotel(1, "Plazza Ath\u00e9n\u00e9e", 24.0, 32.0, "Luxurious"));
        this.fullTextSession.save((Object)new RangeHotel(2, "End of the world Hotel - Left", 0.0, 179.0, "Roots"));
        this.fullTextSession.save((Object)new RangeHotel(3, "End of the world Hotel - Right", 0.0, -179.0, "Cosy"));
        this.fullTextSession.save((Object)new Restaurant(1, "Al's kitchen", "42, space avenue CA8596 BYOB Street", 24.0, 32.0));
        this.fullTextSession.save((Object)new GetterUser(1, 24.0, 32.0));
        this.fullTextSession.save((Object)new DoubleIndexedPOI(1, "Davide D'Alto", 37.780392, -122.513898, "Hibernate team member"));
        this.fullTextSession.save((Object)new DoubleIndexedPOI(2, "Peter O'Tall", 40.723165, -73.987439, ""));
        tx.commit();
    }

    @Test
    public void testIndexing() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        this.assertNumberOfPointsOfInterestWithinRadius(centerLatitude, centerLongitude, 0.0, 1);
        this.assertNumberOfPointsOfInterestWithinRadius(centerLatitude, centerLongitude, 10.0, 1);
        this.assertNumberOfPointsOfInterestWithinRadius(centerLatitude, centerLongitude, 20.0, 4);
        this.assertNumberOfPointsOfInterestWithinRadius(centerLatitude, centerLongitude, 30.0, 6);
    }

    @Test
    public void testDistanceProjection() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.list();
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Object[] thirdResult = (Object[])results.get(2);
        Object[] fourthResult = (Object[])results.get(3);
        Object[] fifthResult = (Object[])results.get(4);
        Object[] sixthResult = (Object[])results.get(5);
        Assert.assertEquals((double)((Double)firstResult[1]), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)((Double)secondResult[1]), (double)10.1582, (double)1.0E-4);
        Assert.assertEquals((double)((Double)thirdResult[1]), (double)11.1195, (double)1.0E-4);
        Assert.assertEquals((double)((Double)fourthResult[1]), (double)15.0636, (double)1.0E-4);
        Assert.assertEquals((double)((Double)fifthResult[1]), (double)22.239, (double)0.001);
        Assert.assertEquals((double)((Double)sixthResult[1]), (double)24.446, (double)0.001);
    }

    @Test
    public void testDistanceSort() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.list();
        Double previousDistance = (Double)((Object[])results.get(0))[1];
        for (int i = 1; i < results.size(); ++i) {
            Object[] projectionEntry = (Object[])results.get(i);
            Double currentDistance = (Double)projectionEntry[1];
            Assert.assertTrue((String)(previousDistance + " should be < " + currentDistance), (previousDistance < currentDistance ? 1 : 0) != 0);
            previousDistance = currentDistance;
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1708")
    public void testNonGeoDistanceSortOnNonSpatialField() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(NonGeoPOI.class).get();
        Query luceneQuery = builder.all().createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{NonGeoPOI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "name"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        try {
            hibQuery.list();
            Assert.fail((String)"Sorting on a field that it is not a coordinate should fail");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Wrong error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000282: "));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1708")
    public void testNonGeoDistanceSortOnMissingField() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(NonGeoPOI.class).get();
        Query luceneQuery = builder.all().createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{NonGeoPOI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        try {
            hibQuery.list();
            Assert.fail((String)"Sorting on a field not indexed should fail");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Wrong error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000283: "));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1470")
    public void testSpatialQueryOnNonSpatialConfiguredEntityThrowsException() throws Exception {
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(MissingSpatialPOI.class).get();
        try {
            builder.spatial().within(1.0, Unit.KM).ofLatitude(0.0).andLongitude(0.0).createQuery();
            Assert.fail((String)"Building an invalid spatial query should fail");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Wrong error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000131"));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1470")
    public void testSpatialQueryOnWrongFieldThrowsException() throws Exception {
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        try {
            builder.spatial().onField("foo").within(1.0, Unit.KM).ofLatitude(0.0).andLongitude(0.0).createQuery();
            Assert.fail((String)"Building an invalid spatial query should fail");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Wrong error message " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000131"));
        }
    }

    @Test
    public void testSpatialAnnotationOnFieldLevel() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Event.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Event.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{Event.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void testSpatialAnnotationWithSubAnnotationsLevel() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(User.class).get();
        Query luceneQuery = builder.spatial().onField("home").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{User.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("home").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{User.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void testSpatialAnnotationWithSubAnnotationsLevelRangeMode() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(UserRange.class).get();
        Query luceneQuery = builder.spatial().within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{UserRange.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{UserRange.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void testSpatialsAnnotation() throws Exception {
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(UserEx.class).get();
        Query luceneQuery = builder.spatial().within(100.0, Unit.KM).ofLatitude(24.0).andLongitude(31.5).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{UserEx.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)1L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("work").within(100.0, Unit.KM).ofLatitude(12.0).andLongitude(27.5).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{UserEx.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void testSpatialAnnotationOnFieldLevelRangeMode() throws Exception {
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(RangeEvent.class).get();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        Query luceneQuery = builder.spatial().onField("location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{RangeEvent.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{RangeEvent.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void testSpatialAnnotationOnClassLevel() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Hotel.class).get();
        Query luceneQuery = builder.spatial().onField("hotel_location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Hotel.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("hotel_location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{Hotel.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void testSpatialAnnotationOnClassLevelRangeMode() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(RangeHotel.class).get();
        Query luceneQuery = builder.spatial().within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{RangeHotel.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{RangeHotel.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
        double endOfTheWorldLatitude = 0.0;
        double endOfTheWorldLongitude = 180.0;
        Query luceneQuery3 = builder.spatial().within(112.0, Unit.KM).ofLatitude(endOfTheWorldLatitude).andLongitude(endOfTheWorldLongitude).createQuery();
        FullTextQuery hibQuery3 = this.fullTextSession.createFullTextQuery(luceneQuery3, new Class[]{RangeHotel.class});
        List results3 = hibQuery3.list();
        Assert.assertEquals((long)2L, (long)results3.size());
        Query luceneQuery4 = builder.spatial().within(100000.0, Unit.KM).ofLatitude(endOfTheWorldLatitude).andLongitude(endOfTheWorldLongitude).createQuery();
        FullTextQuery hibQuery4 = this.fullTextSession.createFullTextQuery(luceneQuery4, new Class[]{RangeHotel.class});
        List results4 = hibQuery4.list();
        Assert.assertEquals((long)3L, (long)results4.size());
    }

    @Test
    public void testSpatialAnnotationOnEmbeddableFieldLevel() throws Exception {
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Restaurant.class).get();
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        Query luceneQuery = builder.spatial().onField("position.location").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Restaurant.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("position.location").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{Restaurant.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void testSpatialLatLongOnGetters() throws Exception {
        double centerLatitude = 24.0;
        double centerLongitude = 31.5;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(GetterUser.class).get();
        Query luceneQuery = builder.spatial().onField("home").within(50.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{GetterUser.class});
        List results = hibQuery.list();
        Assert.assertEquals((long)0L, (long)results.size());
        Query luceneQuery2 = builder.spatial().onField("home").within(51.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery2 = this.fullTextSession.createFullTextQuery(luceneQuery2, new Class[]{GetterUser.class});
        List results2 = hibQuery2.list();
        Assert.assertEquals((long)1L, (long)results2.size());
    }

    @Test
    public void test180MeridianCross() throws Exception {
        double centerLatitude = 37.769645;
        double centerLongitude = -122.446428;
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(DoubleIndexedPOI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(5000.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{DoubleIndexedPOI.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.list();
        Assert.assertEquals((long)2L, (long)results.size());
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Assert.assertEquals((double)6.0492, (double)((Double)firstResult[1]), (double)1.0E-4);
        Assert.assertEquals((double)4132.8166, (double)((Double)secondResult[1]), (double)1.0E-4);
        luceneQuery = builder.spatial().within(5000.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{DoubleIndexedPOI.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "_hibernate_default_coordinates");
        results = hibQuery.list();
        Assert.assertEquals((long)2L, (long)results.size());
        firstResult = (Object[])results.get(0);
        secondResult = (Object[])results.get(1);
        Assert.assertEquals((double)6.0492, (double)((Double)firstResult[1]), (double)1.0E-4);
        Assert.assertEquals((double)4132.8166, (double)((Double)secondResult[1]), (double)1.0E-4);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{POI.class, Event.class, Hotel.class, User.class, UserRange.class, UserEx.class, RangeHotel.class, RangeEvent.class, Restaurant.class, NonGeoPOI.class, GetterUser.class, MissingSpatialPOI.class, DoubleIndexedPOI.class};
    }

    private void assertNumberOfPointsOfInterestWithinRadius(double centerLatitude, double centerLongitude, double radius, int expectedPoiCount) {
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(radius, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        List results = hibQuery.list();
        Assert.assertEquals((String)"Unexpected number of POIs within radius", (long)expectedPoiCount, (long)results.size());
    }
}

