/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.test.DefaultTestResourceManager;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.test.util.BackendTestHelper;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.testing.junit4.CustomRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=CustomRunner.class)
public abstract class SearchTestBase
implements TestResourceManager,
TestConfiguration {
    protected static final Boolean PERFORMANCE_TESTS_ENABLED = TestConstants.arePerformanceTestsEnabled();
    private DefaultTestResourceManager testResourceManager;
    private BackendTestHelper backendTestHelper;

    @Before
    public void setUp() throws Exception {
        this.getTestResourceManager().openSessionFactory();
    }

    @After
    public void tearDown() throws Exception {
        this.getTestResourceManager().defaultTearDown();
    }

    @Override
    public final void openSessionFactory() {
        this.getTestResourceManager().openSessionFactory();
    }

    @Override
    public final void closeSessionFactory() {
        this.getTestResourceManager().closeSessionFactory();
    }

    @Override
    public final SessionFactory getSessionFactory() {
        return this.getTestResourceManager().getSessionFactory();
    }

    @Override
    public final SearchFactory getSearchFactory() {
        return this.getTestResourceManager().getSearchFactory();
    }

    public ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return this.getTestResourceManager().getExtendedSearchIntegrator();
    }

    @Override
    public final Session openSession() {
        return this.getTestResourceManager().openSession();
    }

    @Override
    public final Session getSession() {
        return this.getTestResourceManager().getSession();
    }

    @Override
    public void ensureIndexesAreEmpty() throws IOException {
        this.getTestResourceManager().ensureIndexesAreEmpty();
    }

    @Override
    public Path getBaseIndexDir() {
        return this.getTestResourceManager().getBaseIndexDir();
    }

    @Override
    public Directory getDirectory(Class<?> clazz) {
        return this.getTestResourceManager().getDirectory(clazz);
    }

    @Override
    public void configure(Map<String, Object> settings) {
    }

    @Override
    public Set<String> multiTenantIds() {
        return Collections.emptySet();
    }

    protected int getNumberOfDocumentsInIndex(Class<?> entityType) {
        return this.getBackendTestHelper().getNumberOfDocumentsInIndex(entityType);
    }

    protected int getNumberOfDocumentsInIndex(String indexName) {
        return this.getBackendTestHelper().getNumberOfDocumentsInIndex(indexName);
    }

    protected int getNumberOfDocumentsInIndexByQuery(String indexName, String fieldName, String value) {
        return this.getBackendTestHelper().getNumberOfDocumentsInIndexByQuery(indexName, fieldName, value);
    }

    private synchronized DefaultTestResourceManager getTestResourceManager() {
        if (this.testResourceManager == null) {
            this.testResourceManager = new DefaultTestResourceManager(this, this.getClass());
        }
        return this.testResourceManager;
    }

    private BackendTestHelper getBackendTestHelper() {
        if (this.backendTestHelper == null) {
            this.backendTestHelper = BackendTestHelper.getInstance(this.getTestResourceManager());
        }
        return this.backendTestHelper;
    }
}

