/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.depth.PersonWithBrokenSocialSecurityNumber;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.hibernate.search.testsupport.backend.LeakingBackendQueueProcessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class UsingIdentifierRollbackTest
extends SearchTestBase {
    @Test
    public void testEntityDeletionWithoutIdentifier() {
        ExtendedSearchIntegrator integrator = this.getExtendedSearchIntegrator();
        MockErrorHandler errorHandler = (MockErrorHandler)integrator.getErrorHandler();
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        Document entity = (Document)s.get(Document.class, (Serializable)Long.valueOf(1L));
        Assert.assertNotNull((Object)entity);
        s.delete((Object)entity);
        s.getTransaction().commit();
        s.close();
        Assert.assertNull((String)"unexpected exception detected", (Object)errorHandler.getLastException());
    }

    @Test
    public void testRolledBackIdentifiersOnUnusualDocumentId() {
        ExtendedSearchIntegrator integrator = this.getExtendedSearchIntegrator();
        MockErrorHandler errorHandler = (MockErrorHandler)integrator.getErrorHandler();
        Session s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        s.persist((Object)new PersonWithBrokenSocialSecurityNumber(2L, "This guy is unaffected by identifier rollback"));
        s.getTransaction().commit();
        s.close();
        s = this.getSessionFactory().openSession();
        s.getTransaction().begin();
        PersonWithBrokenSocialSecurityNumber entity = (PersonWithBrokenSocialSecurityNumber)s.get(PersonWithBrokenSocialSecurityNumber.class, (Serializable)Long.valueOf(2L));
        Assert.assertNotNull((Object)entity);
        s.delete((Object)entity);
        s.getTransaction().commit();
        s.close();
        Assert.assertNull((String)"unexpected exception detected", (Object)errorHandler.getLastException());
        List processedQueue = LeakingBackendQueueProcessor.getLastProcessedQueue();
        Assert.assertEquals((long)1L, (long)processedQueue.size());
        LuceneWork luceneWork = (LuceneWork)processedQueue.get(0);
        Assert.assertEquals((Object)"100", (Object)luceneWork.getIdInString());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, PersonWithBrokenSocialSecurityNumber.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.use_identifier_rollback", "true");
        cfg.put("hibernate.search.error_handler", MockErrorHandler.class.getName());
        cfg.put("hibernate.search.default.worker.backend", LeakingBackendQueueProcessor.class.getName());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        LeakingBackendQueueProcessor.reset();
    }
}

