/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.errorhandling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.StreamingOperationExecutorSelector;
import org.hibernate.search.backend.impl.lucene.IndexWriterDelegate;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkExecutor;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.errorhandling.Foo;
import org.hibernate.search.test.errorhandling.MockErrorHandler;
import org.junit.Assert;
import org.junit.Test;

public class LuceneErrorHandlingTest
extends SearchTestBase {
    static final AtomicInteger WORK_COUNTER = new AtomicInteger();

    @Test
    public void testErrorHandling() {
        MockErrorHandler mockErrorHandler = this.getErrorHandlerAndAssertCorrectTypeIsUsed();
        EntityIndexBinding mappingForEntity = this.getExtendedSearchIntegrator().getIndexBinding(Foo.class);
        IndexManager indexManager = mappingForEntity.getIndexManagers()[0];
        ArrayList<DeleteLuceneWork> queue = new ArrayList<DeleteLuceneWork>();
        queue.add(new HarmlessWork("firstWork"));
        queue.add(new HarmlessWork("secondWork"));
        WORK_COUNTER.set(0);
        indexManager.performOperations(queue, null);
        Assert.assertEquals((long)2L, (long)WORK_COUNTER.get());
        WORK_COUNTER.set(0);
        FailingWork firstFailure = new FailingWork("firstFailure");
        queue.add(firstFailure);
        HarmlessWork thirdWork = new HarmlessWork("thirdWork");
        queue.add(thirdWork);
        HarmlessWork fourthWork = new HarmlessWork("fourthWork");
        queue.add(fourthWork);
        indexManager.performOperations(queue, null);
        Assert.assertEquals((long)2L, (long)WORK_COUNTER.get());
        String errorMessage = mockErrorHandler.getErrorMessage();
        Throwable exception = mockErrorHandler.getLastException();
        StringBuilder expectedErrorMessage = new StringBuilder();
        expectedErrorMessage.append("Exception occurred ").append(exception).append("\n");
        expectedErrorMessage.append("Primary Failure:\n");
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)firstFailure);
        expectedErrorMessage.append("Subsequent failures:\n");
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)firstFailure);
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)thirdWork);
        LogErrorHandler.appendFailureMessage((StringBuilder)expectedErrorMessage, (LuceneWork)fourthWork);
        Assert.assertEquals((Object)expectedErrorMessage.toString(), (Object)errorMessage);
        Assert.assertTrue((boolean)(exception instanceof SearchException));
        Assert.assertEquals((Object)"failed work message", (Object)exception.getMessage());
    }

    private MockErrorHandler getErrorHandlerAndAssertCorrectTypeIsUsed() {
        ExtendedSearchIntegrator integrator = this.getExtendedSearchIntegrator();
        ErrorHandler errorHandler = integrator.getErrorHandler();
        Assert.assertTrue((boolean)(errorHandler instanceof MockErrorHandler));
        return (MockErrorHandler)errorHandler;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Foo.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.error_handler", MockErrorHandler.class.getName());
    }

    static class FailingLuceneWorkDelegate
    implements LuceneWorkExecutor {
        FailingLuceneWorkDelegate() {
        }

        public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
        }

        public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
            throw new SearchException("failed work message");
        }
    }

    static class FailingWork
    extends DeleteLuceneWork {
        public FailingWork(String workIdentifier) {
            super((Serializable)((Object)workIdentifier), workIdentifier, Foo.class);
        }

        public <P, R> R acceptIndexWorkVisitor(IndexWorkVisitor<P, R> visitor, P p) {
            if (visitor instanceof StreamingOperationExecutorSelector) {
                return (R)visitor.visitDeleteWork((DeleteLuceneWork)this, p);
            }
            return (R)new FailingLuceneWorkDelegate();
        }

        public String toString() {
            return "FailingWork: " + this.getIdInString();
        }
    }

    static class NoOpLuceneWorkDelegate
    implements LuceneWorkExecutor {
        NoOpLuceneWorkDelegate() {
        }

        public void logWorkDone(LuceneWork work, MassIndexerProgressMonitor monitor) {
        }

        public void performWork(LuceneWork work, IndexWriterDelegate delegate, IndexingMonitor monitor) {
            WORK_COUNTER.incrementAndGet();
        }
    }

    static class HarmlessWork
    extends DeleteLuceneWork {
        public HarmlessWork(String workIdentifier) {
            super((Serializable)((Object)workIdentifier), workIdentifier, Foo.class);
        }

        public <P, R> R acceptIndexWorkVisitor(IndexWorkVisitor<P, R> visitor, P p) {
            if (visitor instanceof StreamingOperationExecutorSelector) {
                return (R)visitor.visitDeleteWork((DeleteLuceneWork)this, p);
            }
            return (R)new NoOpLuceneWorkDelegate();
        }

        public String toString() {
            return "HarmlessWork: " + this.getIdInString();
        }
    }
}

