/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import javax.persistence.EntityManager;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.jpa.Bretzel;
import org.hibernate.search.test.jpa.JPATestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EntityManagerTest
extends JPATestCase {
    private FullTextEntityManager em;
    private Bretzel bretzel;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        this.em.getTransaction().begin();
        this.bretzel = new Bretzel(23, 34);
        this.em.persist((Object)this.bretzel);
        this.em.getTransaction().commit();
        this.em.clear();
    }

    @Test
    public void testMassIndexer() throws Exception {
        Assert.assertEquals((String)"At the beginning of the test there should be an indexed Bretzel", (long)1L, (long)this.countBretzelsViaIndex(this.em));
        this.em.purgeAll(Bretzel.class);
        this.em.flushToIndexes();
        Assert.assertEquals((String)"The index should be empty after an purge and flush", (long)0L, (long)this.countBretzelsViaIndex(this.em));
        this.em.createIndexer(new Class[]{Bretzel.class}).startAndWait();
        Assert.assertEquals((String)"After re-indexing the bretzel should be indexed again", (long)1L, (long)this.countBretzelsViaIndex(this.em));
    }

    @Test
    public void testNonMatchingQueryDoesReturnEmptyResults() throws Exception {
        this.em.getTransaction().begin();
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"saltQty", (Integer)0, (Integer)0, (boolean)true, (boolean)true);
        Assert.assertEquals((long)0L, (long)this.em.createFullTextQuery((Query)query, new Class[0]).getResultList().size());
        this.em.getTransaction().commit();
    }

    @Test
    public void testGetResultList() throws Exception {
        this.em.getTransaction().begin();
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"saltQty", (Integer)23, (Integer)23, (boolean)true, (boolean)true);
        Assert.assertEquals((String)"getResultList should return a result", (long)1L, (long)this.em.createFullTextQuery((Query)query, new Class[0]).getResultList().size());
        this.em.getTransaction().commit();
    }

    @Test
    public void testGetSingleResult() throws Exception {
        this.em.getTransaction().begin();
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"saltQty", (Integer)23, (Integer)23, (boolean)true, (boolean)true);
        Assert.assertEquals((String)"getSingleResult should return a result", (long)23L, (long)((Bretzel)this.em.createFullTextQuery((Query)query, new Class[0]).getSingleResult()).getSaltQty());
        this.em.getTransaction().commit();
    }

    @Test
    public void testGetResultSize() throws Exception {
        this.em.getTransaction().begin();
        NumericRangeQuery query = NumericRangeQuery.newIntRange((String)"saltQty", (Integer)23, (Integer)23, (boolean)true, (boolean)true);
        Assert.assertEquals((String)"Wrong result size", (long)1L, (long)this.em.createFullTextQuery((Query)query, new Class[0]).getResultSize());
        this.em.getTransaction().commit();
    }

    @Test
    public void testIndex() {
        this.em.getTransaction().begin();
        Assert.assertEquals((String)"At the beginning of the test there should be an indexed Bretzel", (long)1L, (long)this.countBretzelsViaIndex(this.em));
        this.em.purgeAll(Bretzel.class);
        this.em.flushToIndexes();
        Assert.assertEquals((String)"The index should be empty after an purge and flush", (long)0L, (long)this.countBretzelsViaIndex(this.em));
        this.em.index(this.em.find(Bretzel.class, (Object)this.bretzel.getId()));
        this.em.getTransaction().commit();
        Assert.assertEquals((String)"After re-indexing the bretzel should be indexed again", (long)1L, (long)this.countBretzelsViaIndex(this.em));
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Bretzel.class};
    }

    private int countBretzelsViaIndex(FullTextEntityManager em) {
        QueryBuilder queryBuilder = em.getSearchFactory().buildQueryBuilder().forEntity(Bretzel.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        FullTextQuery fullTextQuery = em.createFullTextQuery(allQuery, new Class[]{Bretzel.class});
        return fullTextQuery.getResultSize();
    }
}

