/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.dsl;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.dsl.POI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpatialDSLTest
extends SearchTestBase {
    private FullTextSession fullTextSession;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.indexTestData();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testSpatialQueries() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        QueryBuilder builder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Point coordinates = Point.fromDegrees((double)24.0, (double)31.5);
        Query query = builder.spatial().onField("location").within(51.0, Unit.KM).ofCoordinates((Coordinates)coordinates).createQuery();
        List results = this.fullTextSession.createFullTextQuery(query, new Class[]{POI.class}).list();
        Assert.assertEquals((String)"test spatial hash based spatial query", (long)1L, (long)results.size());
        Assert.assertEquals((String)"test spatial hash based spatial query", (Object)"Bozo", (Object)((POI)results.get(0)).getName());
        query = builder.spatial().onField("location").within(500.0, Unit.KM).ofLatitude(48.858333).andLongitude(2.294444).createQuery();
        results = this.fullTextSession.createFullTextQuery(query, new Class[]{POI.class}).list();
        Assert.assertEquals((String)"test spatial hash based spatial query", (long)1L, (long)results.size());
        Assert.assertEquals((String)"test spatial hash based spatial query", (Object)"Tour Eiffel", (Object)((POI)results.get(0)).getName());
        transaction.commit();
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        POI poi = new POI(1, "Tour Eiffel", 48.858333, 2.294444, "Monument");
        this.fullTextSession.persist((Object)poi);
        poi = new POI(2, "Bozo", 24.0, 32.0, "Monument");
        this.fullTextSession.persist((Object)poi);
        tx.commit();
        this.fullTextSession.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{POI.class};
    }
}

