/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.indexmanager.RamIndexManager;
import org.junit.Assert;
import org.junit.Test;

public class IndexManagerOverrideTest {
    @Test
    public void verifyIndexExclusivity() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSession ftSession = builder.setProperty("hibernate.search.Book.indexmanager", "near-real-time").setProperty("hibernate.search." + Foo.class.getName() + ".indexmanager", "org.hibernate.search.testsupport.indexmanager.RamIndexManager").addAnnotatedClass(BlogEntry.class).addAnnotatedClass(Foo.class).addAnnotatedClass(Book.class).addAnnotatedClass(Author.class).openFullTextSession();
        ExtendedSearchIntegrator integrator = (ExtendedSearchIntegrator)ftSession.getSearchFactory().unwrap(ExtendedSearchIntegrator.class);
        ftSession.close();
        IndexManagerHolder allIndexesManager = integrator.getIndexManagerHolder();
        this.checkIndexManagerType(allIndexesManager, "org.hibernate.search.test.configuration.BlogEntry", DirectoryBasedIndexManager.class);
        this.checkIndexManagerType(allIndexesManager, "Book", NRTIndexManager.class);
        this.checkIndexManagerType(allIndexesManager, Foo.class.getName(), RamIndexManager.class);
        builder.close();
    }

    private void checkIndexManagerType(IndexManagerHolder allIndexesManager, String name, Class expectedType) {
        IndexManager indexManager = allIndexesManager.getIndexManager(name);
        Assert.assertEquals((Object)expectedType, indexManager.getClass());
    }

    @Indexed
    @Entity
    @Table(name="Foo")
    public static class Foo {
        @Id
        private int id;
    }
}

