/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.DefaultInstanceInitializer;
import org.hibernate.search.test.embedded.depth.PersonWithBrokenSocialSecurityNumber;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1048")
public class UnorderedIdScanTest {
    @Test
    public void naturalSortAnnotationsRead() {
        JavaReflectionManager reflectionManager = new JavaReflectionManager();
        XClass mappedXClass = reflectionManager.toXClass(PersonWithBrokenSocialSecurityNumber.class);
        UnorderedIdScanTest.tryCreatingDocumentBuilder(mappedXClass, (ReflectionManager)reflectionManager);
    }

    @Test
    public void invertedSortAnnotationsRead() {
        TrickedJavaReflectionManager<PersonWithBrokenSocialSecurityNumber> reflectionManager = new TrickedJavaReflectionManager<PersonWithBrokenSocialSecurityNumber>(PersonWithBrokenSocialSecurityNumber.class);
        XClass mappedXClass = reflectionManager.toXClass(PersonWithBrokenSocialSecurityNumber.class);
        DeclaredMethodsReverter reverted = new DeclaredMethodsReverter(mappedXClass);
        UnorderedIdScanTest.tryCreatingDocumentBuilder(reverted, reflectionManager);
    }

    private static void tryCreatingDocumentBuilder(XClass mappedXClass, ReflectionManager reflectionManager) {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext context = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest((SearchConfiguration)searchConfiguration));
        AnnotationMetadataProvider metadataProvider = new AnnotationMetadataProvider(reflectionManager, context);
        TypeMetadata typeMetadata = metadataProvider.getTypeMetadataFor(reflectionManager.toClass(mappedXClass), (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
        new DocumentBuilderIndexedEntity(mappedXClass, typeMetadata, context, reflectionManager, Collections.emptySet(), DefaultInstanceInitializer.DEFAULT_INITIALIZER);
    }

    static class DeclaredMethodsReverter
    implements XClass {
        private final XClass delegate;

        DeclaredMethodsReverter(XClass delegate) {
            this.delegate = delegate;
        }

        public <T extends Annotation> T getAnnotation(Class<T> arg0) {
            return (T)this.delegate.getAnnotation(arg0);
        }

        public Annotation[] getAnnotations() {
            return this.delegate.getAnnotations();
        }

        public <T extends Annotation> boolean isAnnotationPresent(Class<T> arg0) {
            return this.delegate.isAnnotationPresent(arg0);
        }

        public List<XMethod> getDeclaredMethods() {
            List declaredMethods = this.delegate.getDeclaredMethods();
            Collections.reverse(declaredMethods);
            return declaredMethods;
        }

        public List<XProperty> getDeclaredProperties(String arg0) {
            List declaredProperties = this.delegate.getDeclaredProperties(arg0);
            Collections.reverse(declaredProperties);
            return declaredProperties;
        }

        public List<XProperty> getDeclaredProperties(String arg0, Filter arg1) {
            List declaredProperties = this.delegate.getDeclaredProperties(arg0, arg1);
            Collections.reverse(declaredProperties);
            return declaredProperties;
        }

        public XClass[] getInterfaces() {
            return this.delegate.getInterfaces();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public XClass getSuperclass() {
            return this.delegate.getSuperclass();
        }

        public boolean isAbstract() {
            return this.delegate.isAbstract();
        }

        public boolean isAssignableFrom(XClass arg0) {
            return this.delegate.isAssignableFrom(arg0);
        }

        public boolean isEnum() {
            return this.delegate.isEnum();
        }

        public boolean isInterface() {
            return this.delegate.isInterface();
        }

        public boolean isPrimitive() {
            return this.delegate.isPrimitive();
        }
    }

    static class TrickedJavaReflectionManager<T>
    extends JavaReflectionManager {
        private final Class<T> class1;

        public TrickedJavaReflectionManager(Class<T> class1) {
            this.class1 = class1;
        }

        public Class toClass(XClass xClazz) {
            try {
                return super.toClass(xClazz);
            }
            catch (IllegalArgumentException e) {
                return this.class1;
            }
        }

        public boolean equals(XClass class1, Class class2) {
            if (class1 instanceof DeclaredMethodsReverter) {
                DeclaredMethodsReverter wrapper = (DeclaredMethodsReverter)class1;
                return super.equals(wrapper.delegate, class2);
            }
            return super.equals(class1, class2);
        }
    }
}

