/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Cd;
import org.hibernate.search.test.query.facet.Fruit;
import org.hibernate.search.test.query.facet.Truck;
import org.hibernate.testing.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class RangeFacetingTest
extends AbstractFacetTest {
    private static final String indexFieldName = "price";
    private static final String priceRange = "priceRange";

    @Test
    public void testRangeQueryForInteger() {
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().from((Object)0).to((Object)1000).from((Object)1001).to((Object)1500).from((Object)1501).to((Object)3000).from((Object)3001).to((Object)8000).includeZeroCounts(true).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{5, 3, 2, 0});
    }

    @Test
    public void testRangeBelow() {
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().below((Object)1500).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{5});
    }

    @Test
    public void testRangeBelowExcludeLimit() {
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().below((Object)1500).excludeLimit().createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{2});
    }

    @Test
    public void testRangeAbove() {
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().above((Object)1500).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{8});
    }

    @Test
    public void testRangeAboveExcludeLimit() {
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().above((Object)1500).excludeLimit().createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{5});
    }

    @Test
    public void testRangeAboveBelow() {
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().below((Object)1500).above((Object)1500).excludeLimit().createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{5, 5});
    }

    @Test
    public void testRangeBelowMiddleAbove() {
        String facetingName = "cdPriceFaceting";
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name("cdPriceFaceting").onField(indexFieldName).range().below((Object)1000).from((Object)1001).to((Object)1500).above((Object)1501).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        query.getFacetManager().enableFaceting(rangeRequest);
        List facets = query.getFacetManager().getFacets("cdPriceFaceting");
        this.assertFacetCounts(facets, new int[]{5, 3, 2});
    }

    @Test
    public void testRangeWithExcludeLimitsAtEachLevel() {
        String facetingName = "cdPriceFaceting";
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name("cdPriceFaceting").onField(indexFieldName).range().below((Object)1000).excludeLimit().from((Object)1000).to((Object)1500).excludeLimit().from((Object)1500).to((Object)2000).excludeLimit().above((Object)2000).orderedBy(FacetSortOrder.RANGE_DEFINITION_ORDER).includeZeroCounts(true).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        query.getFacetManager().enableFaceting(rangeRequest);
        List facets = query.getFacetManager().getFacets("cdPriceFaceting");
        this.assertFacetCounts(facets, new int[]{2, 0, 6, 2});
        rangeRequest = this.queryBuilder(Cd.class).facet().name("cdPriceFaceting").onField(indexFieldName).range().below((Object)1000).from((Object)1000).excludeLimit().to((Object)1500).from((Object)1500).excludeLimit().to((Object)2000).above((Object)2000).excludeLimit().orderedBy(FacetSortOrder.RANGE_DEFINITION_ORDER).createFacetingRequest();
        query = this.createMatchAllQuery(Cd.class);
        query.getFacetManager().enableFaceting(rangeRequest);
        facets = query.getFacetManager().getFacets("cdPriceFaceting");
        this.assertFacetCounts(facets, new int[]{2, 3, 4, 1});
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-770")
    public void testRangeBelowWithFacetSelection() {
        String facetingName = "truckHorsePowerFaceting";
        FacetingRequest rangeRequest = this.queryBuilder(Truck.class).facet().name("truckHorsePowerFaceting").onField("horsePower").range().below((Object)1000).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Truck.class);
        FacetManager facetManager = query.getFacetManager();
        query.getFacetManager().enableFaceting(rangeRequest);
        List facets = facetManager.getFacets("truckHorsePowerFaceting");
        facets = facetManager.getFacets("truckHorsePowerFaceting");
        this.assertFacetCounts(facets, new int[]{4});
        facetManager.getFacetGroup("truckHorsePowerFaceting").selectFacets(new Facet[]{(Facet)facets.get(0)});
        facets = facetManager.getFacets("truckHorsePowerFaceting");
        this.assertFacetCounts(facets, new int[]{4});
    }

    @Test
    public void testRangeQueryForDoubleWithZeroCount() {
        FacetingRequest rangeRequest = this.queryBuilder(Fruit.class).facet().name(priceRange).onField(indexFieldName).range().from((Object)0.0).to((Object)1.0).from((Object)1.01).to((Object)1.5).from((Object)1.51).to((Object)3.0).from((Object)4.0).to((Object)5.0).includeZeroCounts(true).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Fruit.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{5, 3, 2, 0});
    }

    @Test
    public void testRangeQueryForDoubleWithoutZeroCount() {
        FacetingRequest rangeRequest = this.queryBuilder(Fruit.class).facet().name(priceRange).onField(indexFieldName).range().from((Object)0.0).to((Object)1.0).from((Object)1.01).to((Object)1.5).from((Object)1.51).to((Object)3.0).from((Object)4.0).to((Object)5.0).includeZeroCounts(false).orderedBy(FacetSortOrder.COUNT_ASC).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Fruit.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = query.getFacetManager().getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{2, 3, 5});
        Assert.assertEquals((Object)"[0.0, 1.0]", (Object)((Facet)facets.get(0)).getValue());
        Assert.assertEquals((Object)"[1.01, 1.5]", (Object)((Facet)facets.get(1)).getValue());
        Assert.assertEquals((Object)"[1.51, 3.0]", (Object)((Facet)facets.get(2)).getValue());
    }

    @Test
    public void testRangeQueryRangeDefOrderHigherMaxCount() {
        FacetingRequest rangeRequest = this.queryBuilder(Fruit.class).facet().name(priceRange).onField(indexFieldName).range().from((Object)0.0).to((Object)1.0).from((Object)1.01).to((Object)1.5).from((Object)1.51).to((Object)3.0).from((Object)4.0).to((Object)5.0).includeZeroCounts(false).orderedBy(FacetSortOrder.RANGE_DEFINITION_ORDER).maxFacetCount(5).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Fruit.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = query.getFacetManager().getFacets(priceRange);
        this.assertFacetCounts(facets, new int[]{2, 3, 5});
        Assert.assertEquals((Object)"[0.0, 1.0]", (Object)((Facet)facets.get(0)).getValue());
        Assert.assertEquals((Object)"[1.01, 1.5]", (Object)((Facet)facets.get(1)).getValue());
        Assert.assertEquals((Object)"[1.51, 3.0]", (Object)((Facet)facets.get(2)).getValue());
    }

    @Test
    public void testDateRangeFaceting() throws Exception {
        String facetingName = "albumYearFaceting";
        String fieldName = "releaseYear";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy", Locale.ROOT);
        FacetingRequest rangeRequest = this.queryBuilder(Cd.class).facet().name("albumYearFaceting").onField("releaseYear").range().below((Object)formatter.parse("1970")).excludeLimit().from((Object)formatter.parse("1970")).to((Object)formatter.parse("1979")).from((Object)formatter.parse("1980")).to((Object)formatter.parse("1989")).from((Object)formatter.parse("1990")).to((Object)formatter.parse("1999")).above((Object)formatter.parse("2000")).excludeLimit().orderedBy(FacetSortOrder.RANGE_DEFINITION_ORDER).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Cd.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        List facets = facetManager.getFacets("albumYearFaceting");
        this.assertFacetCounts(facets, new int[]{1, 2, 2, 5});
        facetManager.getFacetGroup("albumYearFaceting").selectFacets(new Facet[]{(Facet)facets.get(3)});
        facets = facetManager.getFacets("albumYearFaceting");
        this.assertFacetCounts(facets, new int[]{5});
    }

    @Test
    public void testRangeQueryWithUnsupportedType() {
        try {
            this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().from(new Object()).to(new Object()).createFacetingRequest();
            Assert.fail((String)"Unsupported range faceting type");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000269"));
        }
    }

    @Test
    public void testRangeQueryWithNullToAndFrom() {
        try {
            this.queryBuilder(Cd.class).facet().name(priceRange).onField(indexFieldName).range().from(null).to(null).createFacetingRequest();
            Assert.fail((String)"Unsupported range faceting type");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000270"));
        }
    }

    @Test
    public void testUnsupportedRangeParameterTypeThrowsException() {
        FacetingRequest rangeRequest = this.queryBuilder(Fruit.class).facet().name(priceRange).onField(indexFieldName).range().from((Object)"0.00").to((Object)"1.00").createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Fruit.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        try {
            query.getFacetManager().getFacets(priceRange);
            Assert.fail((String)"Trying to so a range query using string as parameter should fail.");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000266"));
        }
    }

    @Override
    public void loadTestData(Session session) {
        int i;
        Transaction tx = session.beginTransaction();
        for (i = 0; i < albums.length; ++i) {
            Cd cd = new Cd(albums[i], albumPrices[i], releaseDates[i]);
            session.save((Object)cd);
        }
        for (i = 0; i < fruits.length; ++i) {
            Fruit fruit = new Fruit(fruits[i], fruitPrices[i]);
            session.save((Object)fruit);
        }
        for (Integer horsePower : horsePowers) {
            Truck truck = new Truck(horsePower);
            session.save((Object)truck);
        }
        tx.commit();
        session.clear();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Cd.class, Fruit.class, Truck.class};
    }
}

