/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.de.GermanStemFilterFactory;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.cfg.ConcatStringBridge;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.configuration.Address;
import org.hibernate.search.test.configuration.AddressClassBridge;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.configuration.CatDeptsFieldsClassBridge;
import org.hibernate.search.test.configuration.ClassLevelTestPoI;
import org.hibernate.search.test.configuration.CustomBoostStrategy;
import org.hibernate.search.test.configuration.CustomFieldBoostStrategy;
import org.hibernate.search.test.configuration.Departments;
import org.hibernate.search.test.configuration.DynamicBoostedDescLibrary;
import org.hibernate.search.test.configuration.EquipmentType;
import org.hibernate.search.test.configuration.Item;
import org.hibernate.search.test.configuration.LatLongAnnTestPoi;
import org.hibernate.search.test.configuration.MemberLevelTestPoI;
import org.hibernate.search.test.configuration.OrderLine;
import org.hibernate.search.test.configuration.OrderLineClassBridge;
import org.hibernate.search.test.configuration.ProductCatalog;
import org.hibernate.search.test.configuration.ProvidedIdEntry;
import org.hibernate.search.test.configuration.SecurityFilterFactory;

public class ProgrammaticSearchMappingFactory {
    private static final String EN_ANALYZER_NAME = "org_hibernate_search_test_configuration_BlogEntry_en";
    private static final String ENGLISH_ANALYZER_NAME = "org_hibernate_search_test_configuration_ProgrammaticSearchMappingFactory_english";
    private static final String DEUTSCH_ANALYZER_NAME = "org_hibernate_search_test_configuration_ProgrammaticSearchMappingFactory_deutsch";
    private static final String NGRAM_ANALYZER_NAME = "org_hibernate_search_test_configuration_ProgrammaticSearchMappingFactory_ngram";

    @Factory
    public SearchMapping build() {
        SearchMapping mapping = new SearchMapping();
        mapping.fullTextFilterDef("security", SecurityFilterFactory.class).cache(FilterCacheModeType.INSTANCE_ONLY).analyzerDef(NGRAM_ANALYZER_NAME, StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(NGramFilterFactory.class).param("minGramSize", "3").param("maxGramSize", "3").analyzerDef(ENGLISH_ANALYZER_NAME, StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(SnowballPorterFilterFactory.class).analyzerDef(DEUTSCH_ANALYZER_NAME, StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(GermanStemFilterFactory.class).entity(Address.class).indexed().boost(2.0f).classBridge(AddressClassBridge.class).analyzer(ENGLISH_ANALYZER_NAME).property("addressId", ElementType.FIELD).documentId().name("id").property("lastUpdated", ElementType.FIELD).field().name("last-updated").analyzer(EN_ANALYZER_NAME).store(Store.YES).calendarBridge(Resolution.DAY).property("dateCreated", ElementType.FIELD).field().name("date-created").index(Index.YES).store(Store.YES).dateBridge(Resolution.DAY).property("owner", ElementType.FIELD).field().property("street1", ElementType.FIELD).field().field().name("street1_ngram").analyzer(NGRAM_ANALYZER_NAME).field().name("street1_abridged").bridge(ConcatStringBridge.class).param("size", "4").property("street2", ElementType.METHOD).field().name("idx_street2").store(Store.YES).boost(2.0f).entity(ProvidedIdEntry.class).indexed().providedId().name("providedidentry.providedid").bridge(LongBridge.class).property("name", ElementType.FIELD).field().name("providedidentry.name").analyzer(EN_ANALYZER_NAME).index(Index.YES).store(Store.YES).property("blurb", ElementType.FIELD).field().name("providedidentry.blurb").analyzer(EN_ANALYZER_NAME).index(Index.YES).store(Store.YES).property("age", ElementType.FIELD).field().name("providedidentry.age").analyzer(EN_ANALYZER_NAME).index(Index.YES).store(Store.YES).entity(ProductCatalog.class).indexed().boost(2.0f).property("id", ElementType.FIELD).documentId().name("id").property("name", ElementType.FIELD).field().name("productCatalogName").index(Index.YES).analyzer(EN_ANALYZER_NAME).store(Store.YES).property("items", ElementType.FIELD).indexEmbedded().includeEmbeddedObjectId(true).entity(Item.class).indexed().property("id", ElementType.FIELD).documentId().sortableField().property("description", ElementType.FIELD).field().name("description").analyzer(EN_ANALYZER_NAME).index(Index.YES).store(Store.YES).property("productCatalog", ElementType.FIELD).containedIn().property("price", ElementType.FIELD).field().store(Store.YES).numericField().precisionStep(10).sortableField().field().name("price_string").store(Store.YES).entity(DynamicBoostedDescLibrary.class).dynamicBoost(CustomBoostStrategy.class).indexed().property("libraryId", ElementType.FIELD).documentId().name("id").property("name", ElementType.FIELD).dynamicBoost(CustomFieldBoostStrategy.class).field().store(Store.YES).entity(Departments.class).classBridge(CatDeptsFieldsClassBridge.class).name("branchnetwork").index(Index.YES).store(Store.YES).param("sepChar", " ").classBridge(EquipmentType.class).name("equiptype").index(Index.YES).store(Store.YES).param("C", "Cisco").param("D", "D-Link").param("K", "Kingston").param("3", "3Com").indexed().property("deptsId", ElementType.FIELD).documentId().name("id").property("branchHead", ElementType.FIELD).field().store(Store.YES).property("network", ElementType.FIELD).field().store(Store.YES).property("branch", ElementType.FIELD).field().store(Store.YES).property("maxEmployees", ElementType.FIELD).field().index(Index.YES).analyze(Analyze.YES).store(Store.YES).entity(BlogEntry.class).indexed().property("title", ElementType.METHOD).field().property("description", ElementType.METHOD).field().property("language", ElementType.METHOD).analyzerDiscriminator(BlogEntry.BlogLangDiscriminator.class).property("dateCreated", ElementType.METHOD).field().name("blog-entry-created").store(Store.YES).dateBridge(Resolution.DAY).entity(MemberLevelTestPoI.class).indexed().property("name", ElementType.METHOD).field().property("location", ElementType.METHOD).spatial().spatialMode(SpatialMode.HASH).entity(ClassLevelTestPoI.class).indexed().spatial().name("location").spatialMode(SpatialMode.HASH).property("name", ElementType.METHOD).field().entity(LatLongAnnTestPoi.class).indexed().spatial().name("location").property("latitude", ElementType.FIELD).latitude().name("location").property("longitude", ElementType.FIELD).longitude().name("location").entity(OrderLine.class).indexed().classBridgeInstance((FieldBridge)new OrderLineClassBridge("orderLineName")).classBridgeInstance((FieldBridge)new OrderLineClassBridge(null)).name("orderLineName_ngram").analyzer(NGRAM_ANALYZER_NAME).classBridgeInstance((FieldBridge)new OrderLineClassBridge(null)).param("fieldName", "orderLineNameViaParam");
        return mapping;
    }
}

