/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.graph;

import org.hibernate.Session;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.graph.Event;
import org.hibernate.search.test.embedded.graph.ParentOfBirthEvent;
import org.hibernate.search.test.embedded.graph.Person;
import org.junit.Assert;
import org.junit.Test;

public class RecursiveGraphTest
extends SearchTestBase {
    @Test
    public void testCreateParentAndChild() throws Exception {
        Person[] people = new Person[2];
        Person parent = new Person();
        parent.setName("parent");
        Person child = new Person();
        child.setName("child");
        this.connectChildToParent(child, parent);
        people[0] = parent;
        people[1] = child;
        this.savePeople(people);
        Assert.assertEquals((long)2L, (long)this.getNumberOfDocumentsInIndex(Person.class));
    }

    private void connectChildToParent(Person child, Person parent) {
        Event birthEvent = child.getBirthEvent();
        child.setBirthEvent(birthEvent);
        ParentOfBirthEvent parentOfBirthEvent = new ParentOfBirthEvent(parent, child.getBirthEvent());
        parent.getParentOfBirthEvents().add(parentOfBirthEvent);
    }

    public void savePeople(Person ... people) {
        for (Person person : people) {
            if (person == null) continue;
            Session s = this.getSessionFactory().openSession();
            s.getTransaction().begin();
            s.save((Object)person);
            s.getTransaction().commit();
            s.close();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Event.class, Person.class, ParentOfBirthEvent.class};
    }
}

