/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed
@Table(name="IBT_Entity")
public class MapBridgeNullEmbeddedTestEntity {
    static final String NULL_TOKEN = "NULL_MARKER";
    static final String NULL_NUMERIC_TOKEN = "-7777";
    static final String NULL_EMBEDDED = "EMBEDDED_NULL";
    static final String NULL_EMBEDDED_NUMERIC = "-4444";
    private Long id;
    private String name;
    private Map<Integer, Language> nullIndexed = new HashMap<Integer, Language>();
    private Map<Integer, Integer> numericNullIndexed = new HashMap<Integer, Integer>();

    @Id
    @GeneratedValue
    @Column(name="iterable_id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="name")
    @Field(store=Store.YES)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(indexNullAs="NULL_MARKER", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(indexNullAs="EMBEDDED_NULL")
    @CollectionTable(name="NullIndexed", joinColumns={@JoinColumn(name="iterable_id")})
    @Column(name="nullIndexed")
    @MapKeyColumn(nullable=false)
    public Map<Integer, Language> getNullIndexed() {
        return this.nullIndexed;
    }

    public void setNullIndexed(Map<Integer, Language> nullIndexed) {
        this.nullIndexed = nullIndexed;
    }

    public void addNullIndexed(Integer key, Language nullIndexed) {
        this.nullIndexed.put(key, nullIndexed);
    }

    @Field(store=Store.YES, indexNullAs="-7777", analyze=Analyze.NO)
    @ElementCollection
    @IndexedEmbedded(prefix="embeddedNum.", indexNullAs="-4444")
    @CollectionTable(name="NumericNullIndexed", joinColumns={@JoinColumn(name="iterable_id")})
    @Column(name="numericNullIndexed")
    @MapKeyColumn(nullable=false)
    public Map<Integer, Integer> getNumericNullIndexed() {
        return this.numericNullIndexed;
    }

    public void setNumericNullIndexed(Map<Integer, Integer> numericNullIndexed) {
        this.numericNullIndexed = numericNullIndexed;
    }

    public void addNumericNullIndexed(Integer key, Integer number) {
        this.numericNullIndexed.put(key, number);
    }

    public String toString() {
        return MapBridgeNullEmbeddedTestEntity.class.getSimpleName() + "[id=" + this.id + ", name=" + this.name + "]";
    }

    public static enum Language {
        ITALIAN,
        ENGLISH,
        PIRATE,
        KLINGON;

    }
}

