/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.testing.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class BridgedReverseBagCollectionUpdateEventTest
extends SearchTestBase {
    @Test
    @TestForIssue(jiraKey="HSEARCH-2868")
    public void collectionUpdateTriggersReindex() {
        NestedEntity nested;
        ContainingEntity parent;
        Transaction tx2;
        try (Session session = this.openSession();){
            tx2 = this.getSession().beginTransaction();
            parent = new ContainingEntity();
            parent.id = 1;
            parent.nested = new ArrayList();
            nested = new NestedEntity();
            nested.id = 11;
            nested.name = "one";
            nested.parent = parent;
            parent.nested.add(nested);
            session.persist((Object)parent);
            tx2.commit();
        }
        session = this.openSession();
        var2_2 = null;
        try {
            Assert.assertNotNull((Object)this.doQuery("one"));
            Assert.assertNull((Object)this.doQuery("two"));
        }
        catch (Throwable tx2) {
            var2_2 = tx2;
            throw tx2;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable tx2) {
                        var2_2.addSuppressed(tx2);
                    }
                } else {
                    session.close();
                }
            }
        }
        session = this.openSession();
        var2_2 = null;
        try {
            tx2 = this.getSession().beginTransaction();
            parent = (ContainingEntity)session.get(ContainingEntity.class, (Serializable)Integer.valueOf(1));
            nested = new NestedEntity();
            nested.id = 12;
            nested.name = "two";
            nested.parent = parent;
            parent.nested.add(nested);
            tx2.commit();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
        session = this.openSession();
        var2_2 = null;
        try {
            Assert.assertNotNull((Object)this.doQuery("two"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    private ContainingEntity doQuery(String twiceNestedEntityName) {
        Transaction tx = this.getSession().beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.getSession());
        TermQuery termQuery = new TermQuery(new Term("nested.name", twiceNestedEntityName));
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)termQuery, new Class[]{ContainingEntity.class});
        ContainingEntity result = (ContainingEntity)fullTextQuery.uniqueResult();
        tx.commit();
        return result;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ContainingEntity.class, NestedEntity.class};
    }

    public static class NestedEntityCollectionFieldBridge
    implements MetadataProvidingFieldBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name, FieldType.OBJECT);
            builder.field(name + ".name", FieldType.STRING);
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Collection collection = (Collection)value;
            for (NestedEntity item : collection) {
                document.add((IndexableField)new TextField(name + ".name", item.name, Field.Store.NO));
            }
        }
    }

    @Entity
    public static class NestedEntity {
        @Id
        private Integer id;
        @ManyToOne
        private ContainingEntity parent;
        @Basic
        @Field
        private String name;
    }

    @Entity
    @Indexed
    public static class ContainingEntity {
        @Id
        private Integer id;
        @OneToMany(mappedBy="parent", cascade={CascadeType.ALL})
        @Field(bridge=@FieldBridge(impl=NestedEntityCollectionFieldBridge.class))
        private List<NestedEntity> nested;
    }
}

