/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-2636")
public class MissingIdTest
extends SearchTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void multipleResults_singleClass() throws Exception {
        EntityWithMissingIdWhenRetrievedFromIndex entity1 = new EntityWithMissingIdWhenRetrievedFromIndex();
        entity1.id = "1";
        EntityWithMissingIdWhenRetrievedFromIndex entity2 = new EntityWithMissingIdWhenRetrievedFromIndex();
        entity2.id = "2";
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)entity1);
        s.save((Object)entity2);
        tx.commit();
        s.clear();
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000338");
        this.thrown.expectMessage("Incomplete entity information");
        this.thrown.expectMessage("'" + EntityWithMissingIdWhenRetrievedFromIndex.class.getName() + "'");
        tx = s.beginTransaction();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{EntityWithMissingIdWhenRetrievedFromIndex.class}).list();
        Assert.assertEquals((long)2L, (long)results.size());
        tx.commit();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{EntityWithMissingIdWhenRetrievedFromIndex.class};
    }

    public static class MissingIdMockingFieldBridge
    implements TwoWayFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, (String)value, document);
        }

        public Object get(String name, Document document) {
            return null;
        }

        public String objectToString(Object object) {
            return (String)object;
        }
    }

    @Entity
    @Indexed
    private class EntityWithMissingIdWhenRetrievedFromIndex {
        @Id
        @FieldBridge(impl=MissingIdMockingFieldBridge.class)
        private String id;

        private EntityWithMissingIdWhenRetrievedFromIndex() {
        }
    }
}

