/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.boost;

import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.boost.BoostedDescriptionLibrary;
import org.hibernate.search.test.query.boost.BoostedFieldDescriptionLibrary;
import org.hibernate.search.test.query.boost.BoostedGetDescriptionLibrary;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;

public class FieldBoostTest
extends SearchTestBase {
    private static final Log log = LoggerFactory.make();

    @Test
    public void testBoostedGetDesc() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.buildBoostedGetIndex(fullTextSession);
        fullTextSession.clear();
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser authorParser = new QueryParser("author", TestConstants.standardAnalyzer);
        QueryParser descParser = new QueryParser("description", TestConstants.standardAnalyzer);
        Query author = authorParser.parse("Wells");
        Query desc = descParser.parse("martians");
        BooleanQuery query = new BooleanQuery.Builder().add(author, BooleanClause.Occur.SHOULD).add(desc, BooleanClause.Occur.SHOULD).build();
        log.debug((Object)query.toString());
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{BoostedGetDescriptionLibrary.class});
        List results = hibQuery.list();
        log.debug((Object)hibQuery.explain(0).toString());
        log.debug((Object)hibQuery.explain(1).toString());
        Assert.assertTrue((String)"incorrect document returned", (boolean)((BoostedGetDescriptionLibrary)results.get(0)).getDescription().startsWith("Martians"));
        for (Object element : fullTextSession.createQuery("from " + BoostedGetDescriptionLibrary.class.getName()).list()) {
            fullTextSession.delete(element);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testBoostedFieldDesc() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.buildBoostedFieldIndex(fullTextSession);
        fullTextSession.clear();
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser authorParser = new QueryParser("author", TestConstants.standardAnalyzer);
        QueryParser descParser = new QueryParser("description", TestConstants.standardAnalyzer);
        Query author = authorParser.parse("Wells");
        Query desc = descParser.parse("martians");
        BooleanQuery query = new BooleanQuery.Builder().add(author, BooleanClause.Occur.SHOULD).add(desc, BooleanClause.Occur.SHOULD).build();
        log.debug((Object)query.toString());
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{BoostedFieldDescriptionLibrary.class});
        List results = hibQuery.list();
        Assert.assertTrue((String)"incorrect document boost", (boolean)((BoostedFieldDescriptionLibrary)results.get(0)).getDescription().startsWith("Martians"));
        log.debug((Object)hibQuery.explain(0).toString());
        log.debug((Object)hibQuery.explain(1).toString());
        for (Object element : fullTextSession.createQuery("from " + BoostedFieldDescriptionLibrary.class.getName()).list()) {
            fullTextSession.delete(element);
        }
        tx.commit();
        fullTextSession.close();
    }

    @Test
    public void testBoostedDesc() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.buildBoostedDescIndex(fullTextSession);
        fullTextSession.clear();
        Transaction tx = fullTextSession.beginTransaction();
        QueryParser authorParser = new QueryParser("author", TestConstants.standardAnalyzer);
        QueryParser descParser = new QueryParser("description", TestConstants.standardAnalyzer);
        Query author = authorParser.parse("Wells");
        Query desc = descParser.parse("martians");
        BooleanQuery query = new BooleanQuery.Builder().add(author, BooleanClause.Occur.SHOULD).add(desc, BooleanClause.Occur.SHOULD).build();
        log.debug((Object)query.toString());
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{BoostedDescriptionLibrary.class});
        List results = hibQuery.list();
        log.debug((Object)hibQuery.explain(0).toString());
        log.debug((Object)hibQuery.explain(1).toString());
        Assert.assertTrue((String)"incorrect document returned", (boolean)((BoostedDescriptionLibrary)results.get(0)).getDescription().startsWith("Martians"));
        for (Object element : fullTextSession.createQuery("from " + BoostedDescriptionLibrary.class.getName()).list()) {
            fullTextSession.delete(element);
        }
        tx.commit();
        fullTextSession.close();
    }

    private void buildBoostedDescIndex(FullTextSession session) {
        Transaction tx = session.beginTransaction();
        BoostedDescriptionLibrary l = new BoostedDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("The Invisible Man");
        l.setDescription("Scientist discovers invisibility and becomes insane.");
        session.save((Object)l);
        l = new BoostedDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("War of the Worlds");
        l.setDescription("Martians invade earth to eliminate mankind.");
        session.save((Object)l);
        tx.commit();
    }

    private void buildBoostedFieldIndex(FullTextSession session) {
        Transaction tx = session.beginTransaction();
        BoostedFieldDescriptionLibrary l = new BoostedFieldDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("The Invisible Man");
        l.setDescription("Scientist discovers invisibility and becomes insane.");
        session.save((Object)l);
        l = new BoostedFieldDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("War of the Worlds");
        l.setDescription("Martians invade earth to eliminate mankind.");
        session.save((Object)l);
        tx.commit();
    }

    private void buildBoostedGetIndex(FullTextSession session) {
        Transaction tx = session.beginTransaction();
        BoostedGetDescriptionLibrary l = new BoostedGetDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("The Invisible Man");
        l.setDescription("Scientist discovers invisibility and becomes insane.");
        session.save((Object)l);
        l = new BoostedGetDescriptionLibrary();
        l.setAuthor("H.G. Wells");
        l.setTitle("War of the Worlds");
        l.setDescription("Martians invade earth to eliminate mankind.");
        session.save((Object)l);
        tx.commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{BoostedDescriptionLibrary.class, BoostedFieldDescriptionLibrary.class, BoostedGetDescriptionLibrary.class};
    }
}

