/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.sorting;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;

@Entity
@Indexed
@ClassBridge(analyze=Analyze.NO, impl=NameFieldBridge.class)
public class Territory {
    @Id
    private int id;
    private String name;

    Territory() {
    }

    public Territory(int id) {
        this.id = id;
    }

    public Territory(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class NameFieldBridge
    implements MetadataProvidingFieldBridge {
        private static final String FIELD_SUFFIX = "territoryName";

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            Territory territory = (Territory)value;
            String territoryName = territory.getName();
            luceneOptions.addFieldToDocument(name + FIELD_SUFFIX, territoryName, document);
            document.add((IndexableField)new SortedDocValuesField(name + FIELD_SUFFIX, new BytesRef((CharSequence)territoryName)));
        }

        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name + FIELD_SUFFIX, FieldType.STRING).sortable(true);
        }
    }

    public static class IdFieldBridge
    implements MetadataProvidingFieldBridge,
    StringBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name, FieldType.INTEGER).sortable(true);
        }

        public String objectToString(Object object) {
            if (!(object instanceof Territory)) {
                throw new IllegalStateException("This field bridge only supports Territory values");
            }
            int id = ((Territory)object).getId();
            return String.valueOf(id);
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            if (!(value instanceof Territory)) {
                throw new IllegalStateException("This field bridge only supports Territory values");
            }
            int id = ((Territory)value).getId();
            luceneOptions.addNumericFieldToDocument(name, (Object)id, document);
            document.add((IndexableField)new NumericDocValuesField(name, (long)id));
        }
    }
}

