/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.spatial;

import java.util.List;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.junit.Assert;
import org.junit.Test;

public class SpatialHashHelperTest {
    @Test
    public void getCellIndexTest() {
        int cellIndex = SpatialHelper.getCellIndex((double)0.1, (double)0.3, (int)1);
        Assert.assertEquals((long)0L, (long)cellIndex);
        int cellIndex2 = SpatialHelper.getCellIndex((double)0.2, (double)0.3, (int)1);
        Assert.assertEquals((long)1L, (long)cellIndex2);
        int cellIndex3 = SpatialHelper.getCellIndex((double)3.0, (double)10.0, (int)4);
        Assert.assertEquals((long)4L, (long)cellIndex3);
        int cellIndex4 = SpatialHelper.getCellIndex((double)6.0, (double)10.0, (int)4);
        Assert.assertEquals((long)9L, (long)cellIndex4);
    }

    @Test
    public void getSpatialHashCellIdTest() {
        Point point = Point.fromDegrees((double)45.0, (double)4.0);
        String cellId = SpatialHelper.getSpatialHashCellId((Point)point, (int)5);
        Assert.assertEquals((Object)"0|8", (Object)cellId);
        String cellId2 = SpatialHelper.getSpatialHashCellId((Point)point, (int)7);
        Assert.assertEquals((Object)"1|32", (Object)cellId2);
        String cellId3 = SpatialHelper.getSpatialHashCellId((Point)point, (int)14);
        Assert.assertEquals((Object)"128|4096", (Object)cellId3);
        Point point2 = Point.fromDegrees((double)-12.0, (double)-179.0);
        String cellId4 = SpatialHelper.getSpatialHashCellId((Point)point2, (int)5);
        Assert.assertEquals((Object)"-16|-3", (Object)cellId4);
        String cellId5 = SpatialHelper.getSpatialHashCellId((Point)point2, (int)7);
        Assert.assertEquals((Object)"-63|-9", (Object)cellId5);
        String cellId6 = SpatialHelper.getSpatialHashCellId((Point)point2, (int)14);
        Assert.assertEquals((Object)"-7969|-1093", (Object)cellId6);
    }

    @Test
    public void findBestSpatialHashLevelForSearchRangeTest() {
        int bestSpatialHashLevel = SpatialHelper.findBestSpatialHashLevelForSearchRange((double)50.0);
        Assert.assertEquals((long)9L, (long)bestSpatialHashLevel);
        int bestSpatialHashLevel2 = SpatialHelper.findBestSpatialHashLevelForSearchRange((double)1.0);
        Assert.assertEquals((long)15L, (long)bestSpatialHashLevel2);
    }

    @Test
    public void projectedBoundingBoxCellsIdsInclusionTest() {
        Point center = Point.fromDegrees((double)45.0, (double)32.0);
        Double radius = 50.0;
        Assert.assertTrue((boolean)this.projectedBoundingBoxCellsIdsInclusionTest(center, radius));
        center = Point.fromDegrees((double)0.0, (double)0.0);
        radius = 100.0;
        Assert.assertTrue((boolean)this.projectedBoundingBoxCellsIdsInclusionTest(center, radius));
        center = Point.fromDegrees((double)180.0, (double)0.0);
        radius = 250.0;
        Assert.assertTrue((boolean)this.projectedBoundingBoxCellsIdsInclusionTest(center, radius));
        center = Point.fromDegrees((double)0.0, (double)90.0);
        radius = 25.0;
        Assert.assertTrue((boolean)this.projectedBoundingBoxCellsIdsInclusionTest(center, radius));
        center = Point.fromDegrees((double)45.0, (double)360.0);
        radius = 100.0;
        Assert.assertTrue((boolean)this.projectedBoundingBoxCellsIdsInclusionTest(center, radius));
        center = Point.fromDegrees((double)-147.0, (double)-24.0);
        radius = 73.0;
        Assert.assertTrue((boolean)this.projectedBoundingBoxCellsIdsInclusionTest(center, radius));
    }

    public boolean projectedBoundingBoxCellsIdsInclusionTest(Point center, Double radius) {
        Integer spatialHashLevel = SpatialHelper.findBestSpatialHashLevelForSearchRange((double)radius);
        List cellsIds = SpatialHelper.getSpatialHashCellsIds((Coordinates)center, (double)radius, (int)spatialHashLevel);
        Point edge = null;
        boolean validated = true;
        for (int heading = 0; heading < 360; ++heading) {
            edge = center.computeDestination(radius.doubleValue(), (double)heading);
            String cellId = SpatialHelper.getSpatialHashCellId((Point)edge, (int)spatialHashLevel);
            validated &= cellsIds.contains(cellId);
        }
        return validated;
    }
}

