/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations.deletebyterm;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.fest.assertions.Assertions;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Test;

public class DeleteByTermTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelatedHierarchiesWithRootNonIndexed() throws Exception {
        FullTextSessionBuilder sessionBuilder = new FullTextSessionBuilder();
        sessionBuilder.addAnnotatedClass(ASubOfRoot.class).addAnnotatedClass(BSubOfRoot.class).build();
        FullTextSession fts = sessionBuilder.openFullTextSession();
        fts.beginTransaction();
        ASubOfRoot a = new ASubOfRoot();
        a.id = "1";
        a.name = "Foo";
        fts.persist((Object)a);
        BSubOfRoot b = new BSubOfRoot();
        b.id = "2";
        b.otherName = "Bar";
        fts.persist((Object)b);
        fts.getTransaction().commit();
        fts.clear();
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)((SearchIntegrator)fts.getSearchFactory().unwrap(SearchIntegrator.class)).getIndexManager("index1");
        WorkspaceHolder backendProcessor = indexManager.getWorkspaceHolder();
        IndexWriter writer = backendProcessor.getIndexResources().getWorkspace().getIndexWriter();
        Document document = new Document();
        document.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        document.add((IndexableField)new TextField("name", "Baz", Field.Store.NO));
        writer.addDocument((Iterable)document);
        writer.commit();
        fts.getTransaction().begin();
        fts.delete(fts.get(ASubOfRoot.class, (Serializable)((Object)a.id)));
        fts.delete(fts.get(BSubOfRoot.class, (Serializable)((Object)b.id)));
        fts.getTransaction().commit();
        fts.close();
        try (IndexReader indexReader = fts.getSearchFactory().getIndexReaderAccessor().open(new String[]{"index1"});){
            Assertions.assertThat((int)indexReader.numDocs()).isEqualTo(0);
        }
        sessionBuilder.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnrelatedHierarchies() throws Exception {
        FullTextSessionBuilder sessionBuilder = new FullTextSessionBuilder();
        sessionBuilder.addAnnotatedClass(ASubOfRoot.class).addAnnotatedClass(Unrelated.class).build();
        FullTextSession fts = sessionBuilder.openFullTextSession();
        fts.beginTransaction();
        ASubOfRoot a = new ASubOfRoot();
        a.id = "1";
        a.name = "Foo";
        fts.persist((Object)a);
        Unrelated b = new Unrelated();
        b.id = "2";
        b.name = "Bar";
        fts.persist((Object)b);
        fts.getTransaction().commit();
        fts.clear();
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)((SearchIntegrator)fts.getSearchFactory().unwrap(SearchIntegrator.class)).getIndexManager("index1");
        WorkspaceHolder backendProcessor = indexManager.getWorkspaceHolder();
        IndexWriter writer = backendProcessor.getIndexResources().getWorkspace().getIndexWriter();
        Document document = new Document();
        document.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        document.add((IndexableField)new TextField("name", "Baz", Field.Store.NO));
        writer.addDocument((Iterable)document);
        writer.commit();
        fts.getTransaction().begin();
        fts.delete(fts.get(ASubOfRoot.class, (Serializable)((Object)a.id)));
        fts.delete(fts.get(Unrelated.class, (Serializable)((Object)b.id)));
        fts.getTransaction().commit();
        fts.close();
        try (IndexReader indexReader = fts.getSearchFactory().getIndexReaderAccessor().open(new String[]{"index1"});){
            Assertions.assertThat((int)indexReader.numDocs()).isEqualTo(1);
        }
        sessionBuilder.close();
    }

    @Entity
    @Indexed(index="index1")
    public static class Unrelated {
        @Id
        public String id;
        @Field
        public String name;
    }

    @Entity
    @Indexed(index="index1")
    public static class BSubOfRoot
    extends RootNonIndexed {
        @Field
        public String otherName;
    }

    @Entity
    @Indexed(index="index1")
    public static class ASubOfRoot
    extends RootNonIndexed {
        @Field
        public String name;
    }

    @Entity
    public static class RootNonIndexed {
        @Id
        public String id;
    }
}

