/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.test.jpa.JPATestCase;
import org.hibernate.search.test.spatial.DoubleIndexedPOI;
import org.hibernate.search.test.spatial.POI;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

public class SpatialQueryingJPATest
extends JPATestCase {
    @Test
    public void testDistanceProjection() throws Exception {
        POI poi = new POI(1, "Distance to 24,32 : 0", 24.0, 32.0, "");
        POI poi2 = new POI(2, "Distance to 24,32 : 10.16", 24.0, 31.9, "");
        POI poi3 = new POI(3, "Distance to 24,32 : 11.12", 23.9, 32.0, "");
        POI poi4 = new POI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, "");
        POI poi5 = new POI(5, "Distance to 24,32 : 22.24", 24.2, 32.0, "");
        POI poi6 = new POI(6, "Distance to 24,32 : 24.45", 24.2, 31.9, "");
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        em.persist((Object)poi);
        em.persist((Object)poi2);
        em.persist((Object)poi3);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.persist((Object)poi4);
        em.persist((Object)poi5);
        em.persist((Object)poi6);
        em.getTransaction().commit();
        em.getTransaction().begin();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = em.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.getResultList();
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Object[] thirdResult = (Object[])results.get(2);
        Object[] fourthResult = (Object[])results.get(3);
        Object[] fifthResult = (Object[])results.get(4);
        Object[] sixthResult = (Object[])results.get(5);
        Assert.assertEquals((double)0.0, (double)((Double)firstResult[1]), (double)0.01);
        Assert.assertEquals((double)10.1582, (double)((Double)secondResult[1]), (double)0.01);
        Assert.assertEquals((double)11.1195, (double)((Double)thirdResult[1]), (double)0.01);
        Assert.assertEquals((double)15.0636, (double)((Double)fourthResult[1]), (double)0.01);
        Assert.assertEquals((double)22.239, (double)((Double)fifthResult[1]), (double)0.02);
        Assert.assertEquals((double)24.446, (double)((Double)sixthResult[1]), (double)0.02);
        List pois = em.createQuery("from " + POI.class.getName()).getResultList();
        for (Object entity : pois) {
            em.remove(entity);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void testDistanceSort() throws Exception {
        POI poi = new POI(1, "Distance to 24,32 : 0", 24.0, 32.0, "");
        POI poi2 = new POI(2, "Distance to 24,32 : 10.16", 24.0, 31.9, "");
        POI poi3 = new POI(3, "Distance to 24,32 : 11.12", 23.9, 32.0, "");
        POI poi4 = new POI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, "");
        POI poi5 = new POI(5, "Distance to 24,32 : 22.24", 24.2, 32.0, "");
        POI poi6 = new POI(6, "Distance to 24,32 : 24.45", 24.2, 31.9, "");
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        em.persist((Object)poi);
        em.persist((Object)poi2);
        em.persist((Object)poi3);
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.persist((Object)poi4);
        em.persist((Object)poi5);
        em.persist((Object)poi6);
        em.getTransaction().commit();
        em.getTransaction().begin();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = em.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.getResultList();
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Object[] thirdResult = (Object[])results.get(2);
        Object[] fourthResult = (Object[])results.get(3);
        Object[] fifthResult = (Object[])results.get(4);
        Object[] sixthResult = (Object[])results.get(5);
        Assert.assertEquals((double)0.0, (double)((Double)firstResult[1]), (double)0.01);
        Assert.assertEquals((double)10.1582, (double)((Double)secondResult[1]), (double)0.01);
        Assert.assertEquals((double)11.1195, (double)((Double)thirdResult[1]), (double)0.01);
        Assert.assertEquals((double)15.0636, (double)((Double)fourthResult[1]), (double)0.01);
        Assert.assertEquals((double)22.239, (double)((Double)fifthResult[1]), (double)0.02);
        Assert.assertEquals((double)24.446, (double)((Double)sixthResult[1]), (double)0.02);
        distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location", true));
        hibQuery.setSort(distanceSort);
        results = hibQuery.getResultList();
        firstResult = (Object[])results.get(0);
        secondResult = (Object[])results.get(1);
        thirdResult = (Object[])results.get(2);
        fourthResult = (Object[])results.get(3);
        fifthResult = (Object[])results.get(4);
        sixthResult = (Object[])results.get(5);
        Assert.assertEquals((double)24.446, (double)((Double)firstResult[1]), (double)0.02);
        Assert.assertEquals((double)22.239, (double)((Double)secondResult[1]), (double)0.02);
        Assert.assertEquals((double)15.0636, (double)((Double)thirdResult[1]), (double)0.01);
        Assert.assertEquals((double)11.1195, (double)((Double)fourthResult[1]), (double)0.01);
        Assert.assertEquals((double)10.1582, (double)((Double)fifthResult[1]), (double)0.01);
        Assert.assertEquals((double)0.0, (double)((Double)sixthResult[1]), (double)0.01);
        List pois = em.createQuery("from " + POI.class.getName()).getResultList();
        for (Object entity : pois) {
            em.remove(entity);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void testDistanceSort2() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        int cnt = 0;
        for (double[] c : new double[][]{{41.04389845, -74.06328534}, {40.64383333, -73.7505}, {40.75666667, -73.9865}, {40.69416667, -73.78166667}, {40.75802992, -73.98532391}, {40.75802992, -73.98532391}, {50.77687257, 6.08431213}, {50.783616, 6.070035}, {50.76066667, 6.08866667}, {50.77683333, 6.08466667}, {50.7765, 6.08416667}}) {
            em.persist((Object)new POI(cnt, "Test_" + cnt, c[0], c[1], ""));
            ++cnt;
        }
        em.getTransaction().commit();
        em.getTransaction().begin();
        double centerLatitude = 50.7753455;
        double centerLongitude = 6.083886799999959;
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(1.8097233616663808, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = em.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setMaxResults(1000);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.getResultList();
        for (Object[] result : results) {
            POI poi = (POI)result[0];
            String message = poi.getName() + " (" + poi.getLatitude() + ", " + poi.getLongitude() + ") is not at " + centerLatitude + ", " + centerLongitude;
            Assert.assertThat((String)message, (Object)((Double)result[1]), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0.0)));
        }
        List pois = em.createQuery("from " + POI.class.getName()).getResultList();
        for (Object entity : pois) {
            em.remove(entity);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2322")
    public void testDistanceSortMissingCoordinatesWholeSegment() throws Exception {
        POI poi = new POI(0, "Distance to 24,32 : 10.16km", 24.0, 31.9, "");
        POI poi2 = new POI(1, "Distance to 24,32 : unknown, 4361.00km if interpreted as 0,0", null, null, "");
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        em.persist((Object)poi);
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.persist((Object)poi2);
        em.getTransaction().commit();
        em.getTransaction().begin();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.all().createQuery();
        FullTextQuery hibQuery = em.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.getResultList();
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Assert.assertEquals((double)10.1582, (double)((Double)firstResult[1]), (double)0.01);
        Assert.assertTrue((String)"Expected a great distance", ((Double)secondResult[1] > 4000.0 ? 1 : 0) != 0);
        distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location", true));
        hibQuery.setSort(distanceSort);
        results = hibQuery.getResultList();
        firstResult = (Object[])results.get(0);
        secondResult = (Object[])results.get(1);
        Assert.assertTrue((String)"Expected a great distance", ((Double)firstResult[1] > 4000.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)10.1582, (double)((Double)secondResult[1]), (double)0.01);
        List pois = em.createQuery("from " + POI.class.getName()).getResultList();
        for (Object entity : pois) {
            em.remove(entity);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void testDistanceSortWithMaxResult() throws Exception {
        POI poi = new POI(1, "Distance to 24,32 : 0", 24.0, 32.0, "");
        POI poi2 = new POI(2, "Distance to 24,32 : 10.16", 24.0, 31.9, "");
        POI poi3 = new POI(3, "Distance to 24,32 : 11.12", 23.9, 32.0, "");
        POI poi4 = new POI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, "");
        POI poi5 = new POI(5, "Distance to 24,32 : 22.24", 24.2, 32.0, "");
        POI poi6 = new POI(6, "Distance to 24,32 : 24.45", 24.2, 31.9, "");
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        em.persist((Object)poi);
        em.persist((Object)poi2);
        em.persist((Object)poi3);
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.persist((Object)poi4);
        em.persist((Object)poi5);
        em.persist((Object)poi6);
        em.getTransaction().commit();
        em.getTransaction().begin();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(POI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = em.createFullTextQuery(luceneQuery, new Class[]{POI.class});
        Sort distanceSort = new Sort((SortField)new DistanceSortField(centerLatitude, centerLongitude, "location"));
        hibQuery.setSort(distanceSort);
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setMaxResults(3);
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.getResultList();
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Object[] thirdResult = (Object[])results.get(2);
        Assert.assertEquals((double)0.0, (double)((Double)firstResult[1]), (double)0.01);
        Assert.assertEquals((double)10.1582, (double)((Double)secondResult[1]), (double)0.01);
        Assert.assertEquals((double)11.1195, (double)((Double)thirdResult[1]), (double)0.01);
        List pois = em.createQuery("from " + POI.class.getName()).getResultList();
        for (Object entity : pois) {
            em.remove(entity);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Test
    public void testDoubleIndexedDistanceProjection() throws Exception {
        DoubleIndexedPOI poi1 = new DoubleIndexedPOI(1, "Distance to 24,32 : 0", 24.0, 32.0, "");
        DoubleIndexedPOI poi2 = new DoubleIndexedPOI(2, "Distance to 24,32 : 10.16", 24.0, 31.9, "");
        DoubleIndexedPOI poi3 = new DoubleIndexedPOI(3, "Distance to 24,32 : 11.12", 23.9, 32.0, "");
        DoubleIndexedPOI poi4 = new DoubleIndexedPOI(4, "Distance to 24,32 : 15.06", 23.9, 32.1, "");
        DoubleIndexedPOI poi5 = new DoubleIndexedPOI(5, "Distance to 24,32 : 22.24", 24.2, 32.0, "");
        DoubleIndexedPOI poi6 = new DoubleIndexedPOI(6, "Distance to 24,32 : 24.45", 24.2, 31.9, "");
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        em.persist((Object)poi1);
        em.persist((Object)poi2);
        em.persist((Object)poi3);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.persist((Object)poi4);
        em.persist((Object)poi5);
        em.persist((Object)poi6);
        em.getTransaction().commit();
        em.getTransaction().begin();
        double centerLatitude = 24.0;
        double centerLongitude = 32.0;
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(DoubleIndexedPOI.class).get();
        Query luceneQuery = builder.spatial().onField("location").within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        FullTextQuery hibQuery = em.createFullTextQuery(luceneQuery, new Class[]{DoubleIndexedPOI.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "location");
        List results = hibQuery.getResultList();
        Object[] firstResult = (Object[])results.get(0);
        Object[] secondResult = (Object[])results.get(1);
        Object[] thirdResult = (Object[])results.get(2);
        Object[] fourthResult = (Object[])results.get(3);
        Object[] fifthResult = (Object[])results.get(4);
        Object[] sixthResult = (Object[])results.get(5);
        Assert.assertEquals((double)((Double)firstResult[1]), (double)0.0, (double)0.01);
        Assert.assertEquals((double)((Double)secondResult[1]), (double)10.1582, (double)0.01);
        Assert.assertEquals((double)((Double)thirdResult[1]), (double)11.1195, (double)0.01);
        Assert.assertEquals((double)((Double)fourthResult[1]), (double)15.0636, (double)0.01);
        Assert.assertEquals((double)((Double)fifthResult[1]), (double)22.239, (double)0.02);
        Assert.assertEquals((double)((Double)sixthResult[1]), (double)24.446, (double)0.02);
        luceneQuery = builder.spatial().within(100.0, Unit.KM).ofLatitude(centerLatitude).andLongitude(centerLongitude).createQuery();
        hibQuery = em.createFullTextQuery(luceneQuery, new Class[]{DoubleIndexedPOI.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "_HSearch_SpatialDistance"});
        hibQuery.setSpatialParameters(centerLatitude, centerLongitude, "_hibernate_default_coordinates");
        results = hibQuery.getResultList();
        firstResult = (Object[])results.get(0);
        secondResult = (Object[])results.get(1);
        thirdResult = (Object[])results.get(2);
        fourthResult = (Object[])results.get(3);
        fifthResult = (Object[])results.get(4);
        sixthResult = (Object[])results.get(5);
        Assert.assertEquals((double)((Double)firstResult[1]), (double)0.0, (double)1.0E-4);
        Assert.assertEquals((double)((Double)secondResult[1]), (double)10.1582, (double)0.01);
        Assert.assertEquals((double)((Double)thirdResult[1]), (double)11.1195, (double)0.01);
        Assert.assertEquals((double)((Double)fourthResult[1]), (double)15.0636, (double)0.01);
        Assert.assertEquals((double)((Double)fifthResult[1]), (double)22.239, (double)0.02);
        Assert.assertEquals((double)((Double)sixthResult[1]), (double)24.446, (double)0.02);
        List pois = em.createQuery("from " + DoubleIndexedPOI.class.getName()).getResultList();
        for (Object entity : pois) {
            em.remove(entity);
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{POI.class, DoubleIndexedPOI.class};
    }
}

